/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.Column;
import java.util.HashMap;

public class Header {
    Column[] cols;

    public Header(Column[] cols) {
        this.cols = cols;
    }

    public int size() {
        return this.cols.length;
    }

    public Column get(int i) {
        return this.cols[i];
    }

    public boolean contains(Column col) {
        return this.locate(col) > -1;
    }

    public int locate(Column col) {
        if (col == null) {
            return -1;
        }
        for (int i = 0; i < this.cols.length; ++i) {
            if (!this.cols[i].equals(col)) continue;
            return i;
        }
        return -1;
    }

    public Header union(Header h) {
        String key;
        Column col;
        HashMap<String, Column> map = new HashMap<String, Column>(3);
        int i = 0;
        for (i = 0; i < this.cols.length; ++i) {
            col = this.cols[i];
            key = col.getName();
            if (map.containsKey(key)) continue;
            map.put(key, col);
        }
        for (i = 0; i < h.cols.length; ++i) {
            col = h.cols[i];
            key = col.getName();
            if (map.containsKey(key)) continue;
            map.put(key, col);
        }
        Column[] result = new Column[map.size()];
        map.values().toArray(result);
        return new Header(result);
    }

    public Header intersect(Header h) {
        String key;
        Column col;
        HashMap<String, Column> map1 = new HashMap<String, Column>(5);
        HashMap<String, Column> map2 = new HashMap<String, Column>(5);
        int i = 0;
        for (i = 0; i < this.cols.length; ++i) {
            col = this.cols[i];
            key = col.getName();
            if (map1.containsKey(key)) continue;
            map1.put(key, col);
        }
        for (i = 0; i < h.cols.length; ++i) {
            col = h.cols[i];
            key = col.getName();
            if (map2.containsKey(key)) continue;
            map2.put(key, col);
        }
        String[] keys = new String[map1.size()];
        map1.keySet().toArray(keys);
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (map2.containsKey(key)) continue;
            map1.remove(key);
        }
        Column[] result = new Column[map1.size()];
        map1.values().toArray(result);
        return new Header(result);
    }

    public Header difference(Header h) {
        String key;
        Column col;
        HashMap<String, Column> map1 = new HashMap<String, Column>(3);
        HashMap<String, Column> map2 = new HashMap<String, Column>(3);
        int i = 0;
        for (i = 0; i < this.cols.length; ++i) {
            col = this.cols[i];
            key = col.getName();
            if (map1.containsKey(key)) continue;
            map1.put(key, col);
        }
        for (i = 0; i < h.cols.length; ++i) {
            col = h.cols[i];
            key = col.getName();
            if (map2.containsKey(key)) continue;
            map2.put(key, col);
        }
        String[] keys = new String[map1.size()];
        map1.keySet().toArray(keys);
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (!map2.containsKey(key)) continue;
            map1.remove(key);
        }
        Column[] result = new Column[map1.size()];
        map1.values().toArray(result);
        return new Header(result);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < this.cols.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(this.cols[i].getName());
        }
        buf.append(')');
        return buf.toString();
    }
}

