/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.StringTable;
import java.util.StringTokenizer;

public final class IDManager {
    private static StringTable strTable;
    private static StringBuffer dataBuffer;

    public static int getID(Object o) {
        if (o == null) {
            return IDManager.getID((String)null);
        }
        return IDManager.getID(o.toString());
    }

    public static int getID(String s) {
        return strTable.add(s);
    }

    public static String get(int ID2) {
        String s = strTable.get(ID2);
        if (strTable.isComposite(ID2)) {
            return IDManager.parse(s);
        }
        return s;
    }

    public static boolean isComposite(int ID2) {
        return strTable.isComposite(ID2);
    }

    public static int[] parse(int ID2) {
        int[] result;
        if (strTable.isComposite(ID2)) {
            String s = strTable.get(ID2);
            StringTokenizer st = new StringTokenizer(s, ":");
            result = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                try {
                    result[i] = Integer.parseInt(st.nextToken());
                    ++i;
                }
                catch (NumberFormatException e) {
                    result = new int[]{ID2};
                    break;
                }
            }
        } else {
            result = new int[]{ID2};
        }
        return result;
    }

    public static int getID(int[] ids) {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < ids.length; ++i) {
            buf.append(ids[i]);
            buf.append(":");
        }
        if (i > 1) {
            buf.delete(buf.length() - 1, buf.length());
        }
        return strTable.addComposite(buf.toString());
    }

    public static int getID(int n1, int n2) {
        return strTable.addComposite(n1 + ":" + n2);
    }

    public static int getID(int n1, int n2, int n3) {
        return strTable.addComposite(n1 + ":" + n2 + ":" + n3);
    }

    public static int getReplaceID(int ID2) {
        if (strTable.isComposite(ID2)) {
            int[] ids = IDManager.parse(ID2);
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = IDManager.getReplaceID(ids[i]);
            }
            return IDManager.getID(ids);
        }
        return strTable.getReplace(ID2);
    }

    public static EdgeSet getID() {
        EdgeSet all = new EdgeSet();
        all.data = strTable.getID();
        all.sortLevel = 2;
        return all;
    }

    public static NodeSet getENT() {
        NodeSet all = new NodeSet();
        all.data = strTable.getENT();
        all.sortLevel = 0;
        return all;
    }

    public static NodeSet getAllCompositeIDs() {
        NodeSet comIDs = new NodeSet();
        comIDs.data = strTable.getAllComposites();
        return comIDs;
    }

    private static String parse(String s) {
        dataBuffer.delete(0, dataBuffer.length());
        dataBuffer.append('(');
        StringTokenizer st = new StringTokenizer(s, ":");
        while (st.hasMoreTokens()) {
            try {
                int num = Integer.parseInt(st.nextToken());
                dataBuffer.append(IDManager.get(num));
                dataBuffer.append(' ');
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        dataBuffer.delete(dataBuffer.length() - 1, dataBuffer.length());
        dataBuffer.append(')');
        return dataBuffer.toString();
    }

    static {
        dataBuffer = new StringBuffer();
        strTable = StringTable.instance();
    }
}

