/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.StringTable;
import ca.uwaterloo.cs.jgrok.util.Bytes;
import java.util.StringTokenizer;

public class IDManager2 {
    private static StringTable strTable;
    private static String tag;
    private static StringBuffer buffer;
    private static StringBuffer dataBuffer;

    public static int getID(Object o) {
        return IDManager2.getID(o.toString());
    }

    public static int getID(String s) {
        return strTable.add(s);
    }

    public static boolean isComposite(int ID2) {
        return strTable.isComposite(ID2);
    }

    public static int[] parse(int ID2) {
        int[] result;
        if (strTable.isComposite(ID2)) {
            String s = strTable.get(ID2);
            StringTokenizer st = new StringTokenizer(s, ":");
            result = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                try {
                    result[i] = Integer.parseInt(st.nextToken());
                    ++i;
                }
                catch (NumberFormatException e) {
                    result = new int[]{ID2};
                    break;
                }
            }
        } else {
            result = new int[]{ID2};
        }
        return result;
    }

    public static int getID(int[] ids) {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < ids.length; ++i) {
            buf.append(ids[i]);
            buf.append(":");
        }
        if (i > 1) {
            buf.delete(buf.length() - 1, buf.length());
        }
        return strTable.addComposite(buf.toString());
    }

    public static int getReplaceID(int ID2) {
        if (strTable.isComposite(ID2)) {
            int[] ids = IDManager2.parse(ID2);
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = IDManager2.getReplaceID(ids[i]);
            }
            return IDManager2.getID(ids);
        }
        return strTable.getReplace(ID2);
    }

    public static EdgeSet getID() {
        EdgeSet all = new EdgeSet();
        all.data = strTable.getID();
        all.sortLevel = 2;
        return all;
    }

    public static NodeSet getENT() {
        NodeSet all = new NodeSet();
        all.data = strTable.getENT();
        all.sortLevel = 0;
        return all;
    }

    public static NodeSet getAllCompositeIDs() {
        NodeSet comIDs = new NodeSet();
        comIDs.data = strTable.getAllComposites();
        return comIDs;
    }

    public static String get(int ID2) {
        String s = strTable.get(ID2);
        if (s == null) {
            return s;
        }
        if (!s.startsWith(tag)) {
            return s;
        }
        String composite = IDManager2.parse(s.substring(2));
        if (composite == null) {
            return s;
        }
        return composite;
    }

    public static int getID(int n1, int n2) {
        buffer.delete(2, buffer.length());
        buffer.append(Bytes.encode(n1));
        buffer.append(Bytes.encode(n2));
        return strTable.add(buffer.toString());
    }

    public static int getID(int n1, int n2, int n3) {
        buffer.delete(2, buffer.length());
        buffer.append(Bytes.encode(n1));
        buffer.append(Bytes.encode(n2));
        buffer.append(Bytes.encode(n3));
        return strTable.add(buffer.toString());
    }

    private static String parse(String s) {
        byte[] a = s.getBytes();
        byte[] b = new byte[4];
        if (a.length % 4 == 0) {
            dataBuffer.delete(0, dataBuffer.length());
            dataBuffer.append('(');
            for (int i = 0; i < a.length; ++i) {
                b[0] = a[i];
                b[1] = a[++i];
                b[2] = a[++i];
                b[3] = a[++i];
                dataBuffer.append(IDManager2.get(Bytes.toInt(b)));
                dataBuffer.append(' ');
            }
            dataBuffer.delete(dataBuffer.length() - 2, dataBuffer.length());
            dataBuffer.append(')');
            return dataBuffer.toString();
        }
        return null;
    }

    static {
        tag = "[!]";
        buffer = new StringBuffer(tag);
        dataBuffer = new StringBuffer();
        strTable = StringTable.instance();
    }
}

