/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Node;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleListFactory;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import java.io.OutputStream;
import java.io.PrintWriter;

public class NodeSet
extends TupleSet {
    public NodeSet() {
        this.data = TupleListFactory.newNodeList();
    }

    public NodeSet(String name) {
        super(name);
        this.data = TupleListFactory.newNodeList();
    }

    public NodeSet(int capacity) {
        this.data = TupleListFactory.newNodeList(capacity);
    }

    public static NodeSet singleton(int nodeID) {
        NodeSet set = new NodeSet(1);
        set.data.add(new Tuple4Node(nodeID));
        set.unsetFlag(4);
        set.sortLevel = 0;
        return set;
    }

    public static NodeSet singleton(String node) {
        NodeSet set = new NodeSet(1);
        set.add(node);
        set.sortLevel = 0;
        set.unsetFlag(4);
        return set;
    }

    public void add(int nodeID) {
        this.data.add(new Tuple4Node(nodeID));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public void add(String node) {
        this.data.add(new Tuple4Node(IDManager.getID(node)));
        this.sortLevel = -1;
        this.flags = 0;
    }

    @Override
    public TupleSet newSet() {
        return new NodeSet();
    }

    public boolean contain(String node) {
        this.trySort(0);
        return BinarySearch.search(this.data, IDManager.getID(node), 0) > -1;
    }

    public String pick() {
        int random = (int)(Math.random() * (double)this.data.size());
        int nodeID = this.data.get(random).getDom();
        return IDManager.get(nodeID);
    }

    public NodeSet pick(int num) {
        int size = this.data.size();
        if (num < 1) {
            return new NodeSet();
        }
        if (num >= size) {
            return (NodeSet)this.clone();
        }
        NodeSet result = new NodeSet();
        boolean b = false;
        int step = size / num;
        if (step == 1) {
            b = true;
            num = size - num;
            step = size / num;
        }
        for (int i = 0; i < num; ++i) {
            int random = (int)(Math.random() * (double)step);
            int index = i * step + random;
            result.add(this.data.get(index).getDom());
        }
        if (b) {
            result = AlgebraOperation.difference(this, result);
        }
        return result;
    }

    public Node[] getAllNodes() {
        int size = this.data.size();
        Node[] all = new Node[size];
        for (int i = 0; i < size; ++i) {
            all[i] = new Node(this.data.get(i).getDom());
        }
        return all;
    }

    @Override
    public void print(OutputStream out) {
        PrintWriter writer = new PrintWriter(out, true);
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.data.get(i);
            writer.println(IDManager.get(t.getDom()));
        }
        writer.flush();
    }

    public void prefixCat(String s) {
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            Tuple t = this.data.get(i);
            int nodeID = t.getDom();
            nodeID = IDManager.getID(s + IDManager.get(nodeID));
            t.setDom(nodeID);
        }
        this.sortLevel = -1;
    }

    public void suffixCat(String s) {
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            Tuple t = this.data.get(i);
            int nodeID = t.getDom();
            nodeID = IDManager.getID(IDManager.get(nodeID) + s);
            t.setDom(nodeID);
        }
        this.sortLevel = -1;
    }

    @Override
    protected void sort() {
        this.trySort(0);
    }

    @Override
    protected void sortDom() {
        this.trySort(0);
    }

    @Override
    protected void sortRng() {
        this.trySort(0);
    }

    @Override
    protected void trySort(int level) {
        int col = 0;
        switch (level) {
            case 0: {
                if (this.sortLevel >= 0) break;
                TupleList t_l = TupleListFactory.newNodeList(this.data.size());
                RadixSorter.sort(this.data, col, t_l);
                this.data.setList(t_l.getList());
                this.sortLevel = 0;
                break;
            }
            default: {
                this.trySort(0);
            }
        }
    }
}

