/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Node;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

class Operation {
    Operation() {
    }

    static TupleList union(TupleList list1, TupleList list2) {
        TupleList l = new TupleList(list1.size());
        l.addAll(list1);
        if (list1 != list2) {
            l.addAll(list2);
        }
        return l;
    }

    static TupleList difference(TupleList list1, TupleList list2) {
        int count1 = list1.size();
        int count2 = list2.size();
        int j = 0;
        boolean i_add = true;
        TupleList l = new TupleList();
        for (int i = 0; i < count1; ++i) {
            int val;
            Tuple t2;
            i_add = true;
            Tuple t1 = list1.get(i);
            while (j < count2) {
                t2 = list2.get(j);
                val = t1.compareTo(t2);
                if (val < 0) {
                    if (i_add) {
                        l.add(t1);
                        break;
                    }
                    --j;
                    break;
                }
                if (val == 0) {
                    i_add = false;
                }
                ++j;
            }
            if (j < count2) continue;
            if (!i_add) {
                ++i;
                while (i < count1 && (val = t1.compareTo(t2 = list1.get(i))) == 0) {
                    ++i;
                }
            }
            while (i < count1) {
                l.add(list1.get(i));
                ++i;
            }
            break;
        }
        return l;
    }

    static TupleList intersection(TupleList list1, TupleList list2) {
        int count1 = list1.size();
        int count2 = list2.size();
        int j = 0;
        TupleList l = new TupleList();
        block0: for (int i = 0; i < count1; ++i) {
            Tuple t1 = list1.get(i);
            while (j < count2) {
                Tuple t2 = list2.get(j);
                int val = t1.compareTo(t2);
                if (val == 0) {
                    l.add(t1);
                    ++j;
                    continue block0;
                }
                if (val < 0) continue block0;
                ++j;
            }
        }
        return l;
    }

    static TupleList composition(TupleList list1, TupleList list2) {
        int count1 = list1.size();
        int count2 = list2.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        int j = 0;
        block0: for (int i = 0; i < count1; ++i) {
            Tuple t1 = list1.get(i);
            int v1 = t1.getRng();
            while (j < count2) {
                Tuple t2 = list2.get(j);
                int v2 = t2.getDom();
                if (v1 == v2) {
                    Tuple tmp;
                    for (int k = j; k < count2 && v1 == (tmp = list2.get(k)).getDom(); ++k) {
                        l.add(new Tuple4Edge(t1.getDom(), tmp.getRng()));
                    }
                    continue block0;
                }
                if (v1 < v2) continue block0;
                ++j;
            }
        }
        return l;
    }

    static TupleList tertiary(TupleList list1, TupleList list2, boolean tupleCanBeLoop) {
        int count1 = list1.size();
        int count2 = list2.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        int j = 0;
        int[] dat = new int[3];
        block0: for (int i = 0; i < count1; ++i) {
            Tuple t1 = list1.get(i);
            int v1 = t1.getRng();
            while (j < count2) {
                Tuple t2 = list2.get(j);
                int v2 = t2.getDom();
                if (v1 == v2) {
                    Tuple tmp;
                    for (int k = j; k < count2 && v1 == (tmp = list2.get(k)).getDom(); ++k) {
                        dat[0] = t1.getDom();
                        dat[1] = v1;
                        dat[2] = tmp.getRng();
                        if (tupleCanBeLoop) {
                            l.add(new TupleImpl(dat));
                            continue;
                        }
                        if (dat[0] == dat[1] || dat[1] == dat[2]) continue;
                        l.add(new TupleImpl(dat));
                    }
                    continue block0;
                }
                if (v1 < v2) continue block0;
                ++j;
            }
        }
        return l;
    }

    static TupleList inverse(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList(count);
        for (int i = 0; i < count; ++i) {
            l.add(list.get(i).getInverse());
        }
        return l;
    }

    static TupleList domainOf(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList();
        if (count > 0) {
            int dom = list.get(0).getDom();
            l.add(new Tuple4Node(dom));
            for (int i = 1; i < count; ++i) {
                int next = list.get(i).getDom();
                if (dom == next) continue;
                l.add(new Tuple4Node(next));
                dom = next;
            }
        }
        return l;
    }

    static TupleList rangeOf(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList();
        if (count > 0) {
            int rng = list.get(0).getRng();
            l.add(new Tuple4Node(rng));
            for (int i = 1; i < count; ++i) {
                int next = list.get(i).getRng();
                if (rng == next) continue;
                l.add(new Tuple4Node(next));
                rng = next;
            }
        }
        return l;
    }

    static TupleList entityOf(TupleList list) {
        TupleList l;
        int count = list.size();
        if (count > 0) {
            l = new TupleList(list.size());
            ArrayList<Tuple> a_list = l.getList();
            for (int i = 0; i < count; ++i) {
                Tuple t = list.get(i);
                for (int j = 0; j < t.size(); ++j) {
                    a_list.add(new Tuple4Node(t.get(j)));
                }
            }
            l.sort_removeDuplicates();
        } else {
            l = new TupleList();
        }
        return l;
    }

    static TupleList id(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList(count);
        for (int i = 0; i < count; ++i) {
            Tuple t = list.get(i);
            for (int j = 0; j < t.size(); ++j) {
                l.add(new Tuple4Edge(t.get(j), t.get(j)));
            }
        }
        l.sort(0);
        l.removeDuplicates();
        return l;
    }

    static TupleList reach(TupleList list1, TupleList list2) {
        TupleList result = new TupleList(512);
        TupleList base = new TupleList(list1.size());
        base.addAll(list1);
        TupleList partialBase = base;
        while (partialBase.size() > 0) {
            TupleList partial = Operation.composition(partialBase, list2);
            TupleList partialSorted = new TupleList(partial.size());
            RadixSorter.sort(partial, 1, partialSorted);
            partialBase = Operation.diffUnion(Operation.rangeOf(partialSorted), base);
            partial = new TupleList(partialSorted.size());
            RadixSorter.sort(partialSorted, 0, partial);
            partial.removeDuplicates();
            Operation.diffUnion(partial, result);
        }
        return result;
    }

    static TupleList unclosure(TupleList list) {
        TupleList r_1;
        int rngCol = 1;
        list.sort_removeDuplicates();
        TupleList r_n = r_1 = Operation.difference(list, Operation.id(list));
        TupleList shadow = new TupleList(r_n.size());
        RadixSorter.sort(r_n, rngCol, shadow);
        while (r_n.size() > 0) {
            r_n = Operation.composition(shadow, r_1);
            r_n.sort_removeDuplicates();
            r_1 = Operation.difference(r_1, r_n);
            shadow = new TupleList(r_n.size());
            RadixSorter.sort(r_n, rngCol, shadow);
        }
        return r_1;
    }

    static TupleList closure(TupleList list, boolean reflective) {
        int rngCol = 1;
        list.sort_removeDuplicates();
        TupleList result = new TupleList(list.size());
        result.addAll(list);
        if (reflective) {
            Operation.diffUnion(Operation.id(list), result);
        }
        TupleList base = new TupleList(list.size());
        RadixSorter.sort(list, rngCol, base);
        TupleList partialSorted = list;
        while (partialSorted.size() > 0) {
            TupleList partial = Operation.composition(base, partialSorted);
            partial.sort_removeDuplicates();
            partialSorted = Operation.diffUnion(partial, result);
        }
        return result;
    }

    static TupleList pathClosure(TupleList list) {
        int rngCol = 1;
        list.sort_removeDuplicates();
        int size = list.size();
        int[] dat = new int[3];
        TupleList result = new TupleList(size);
        for (int i = 0; i < size; ++i) {
            Tuple t = list.get(i);
            dat[0] = t.getDom();
            dat[1] = 0;
            dat[2] = t.getRng();
            result.add(new TupleImpl(dat));
        }
        TupleList base = new TupleList(list.size());
        RadixSorter.sort(list, rngCol, base);
        TupleList partialSorted = list;
        while (partialSorted.size() > 0) {
            TupleList partial = Operation.tertiary(base, partialSorted, false);
            partial.sort_removeDuplicates();
            partialSorted = Operation.diffUnion(partial, result);
        }
        return result;
    }

    static TupleList diffUnion(TupleList list1, TupleList list2) {
        int count1 = list1.size();
        int count2 = list2.size();
        int j = 0;
        TupleList l = new TupleList(count1);
        LinkedList<Tuple> linked = new LinkedList<Tuple>();
        for (int i = 0; i < count1; ++i) {
            int val;
            Tuple t2;
            Tuple t1 = list1.get(i);
            while (j < count2) {
                t2 = list2.get(j);
                val = t1.compareTo(t2);
                if (val < 0) {
                    l.add(t1);
                    linked.add(t1);
                    break;
                }
                if (val == 0) {
                    linked.add(t2);
                    ++j;
                    break;
                }
                linked.add(t2);
                ++j;
            }
            if (j != count2) continue;
            if (j > 0 && (val = t1.compareTo(t2 = list2.get(j - 1))) == 0) {
                ++i;
            }
            while (i < count1) {
                t1 = list1.get(i);
                l.add(t1);
                linked.add(t1);
                ++i;
            }
            break;
        }
        while (j < count2) {
            linked.add(list2.get(j));
            ++j;
        }
        list2.setList(new ArrayList<Tuple>(linked.size()));
        Iterator iter = linked.iterator();
        while (iter.hasNext()) {
            list2.add((Tuple)iter.next());
        }
        return l;
    }

    static TupleList symmetricClosure(TupleList list) {
        System.out.println("Not implemented yet: Operation.symmetricClosure()");
        return new TupleList();
    }

    static boolean subsetOf(TupleList list1, TupleList list2) {
        int cmp = Operation.comparison(list1, list2);
        return cmp == -1 || cmp == 0;
    }

    static int comparison(TupleList list1, TupleList list2) {
        TupleList diff1 = Operation.difference(list1, list2);
        TupleList diff2 = Operation.difference(list2, list1);
        if (diff1.size() == 0) {
            if (diff2.size() == 0) {
                return 0;
            }
            return -1;
        }
        if (diff2.size() == 0) {
            return 1;
        }
        return 3;
    }

    static TupleList localof(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList();
        if (count > 0) {
            int ind = 0;
            int rng = list.get(0).getRng();
            for (int i = 1; i < count; ++i) {
                int next = list.get(i).getRng();
                if (rng == next) {
                    ind = -1;
                    continue;
                }
                if (ind != -1) {
                    l.add(new Tuple4Edge(rng, list.get(ind).getDom()));
                }
                ind = i;
                rng = next;
            }
            if (ind != -1) {
                l.add(new Tuple4Edge(rng, list.get(ind).getDom()));
            }
        }
        return l;
    }

    static TupleList outdegree(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList();
        if (count > 0) {
            int deg = 1;
            int dom = list.get(0).getDom();
            for (int i = 1; i < count; ++i) {
                int next = list.get(i).getDom();
                if (dom == next) {
                    ++deg;
                    continue;
                }
                l.add(new Tuple4Edge(dom, IDManager.getID("" + deg)));
                deg = 1;
                dom = next;
            }
            l.add(new Tuple4Edge(dom, IDManager.getID("" + deg)));
        }
        return l;
    }

    static TupleList forwardProjection(TupleList s_l, TupleList r_l) {
        int count1 = s_l.size();
        int count2 = r_l.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        int j = 0;
        block0: for (int i = 0; i < count1; ++i) {
            Tuple t1 = s_l.get(i);
            int v1 = t1.getRng();
            while (j < count2) {
                Tuple t2 = r_l.get(j);
                int v2 = t2.getDom();
                if (v1 == v2) {
                    l.add(new Tuple4Node(t2.getRng()));
                } else if (v1 < v2) continue block0;
                ++j;
            }
        }
        l.sort_removeDuplicates();
        return l;
    }

    static TupleList backwardProjection(TupleList r_l, TupleList s_l) {
        int count1 = r_l.size();
        int count2 = s_l.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        int i = 0;
        block0: for (int j = 0; j < count2; ++j) {
            Tuple t2 = s_l.get(j);
            int v2 = t2.getDom();
            while (i < count1) {
                Tuple t1 = r_l.get(i);
                int v1 = t1.getRng();
                if (v2 == v1) {
                    l.add(new Tuple4Node(t1.getDom()));
                } else if (v2 < v1) continue block0;
                ++i;
            }
        }
        l.sort_removeDuplicates();
        return l;
    }

    static TupleList crossProduct(TupleList s_l, TupleList d_l) {
        int count1 = s_l.size();
        int count2 = d_l.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        for (int i = 0; i < count1; ++i) {
            Tuple t1 = s_l.get(i);
            int v1 = t1.getDom();
            for (int j = 0; j < count2; ++j) {
                Tuple t2 = d_l.get(j);
                int v2 = t2.getDom();
                l.add(new Tuple4Edge(v1, v2));
            }
        }
        return l;
    }

    static TupleList delset(TupleList list, TupleList set) {
        int count = list.size();
        int setCount = set.size();
        TupleList l = new TupleList();
        if (count > 0) {
            Tuple t;
            int i;
            int j = 0;
            int val = -1;
            boolean i_add = true;
            for (i = 0; i < count; ++i) {
                i_add = true;
                t = list.get(i);
                int dom = t.getDom();
                while (j < setCount) {
                    val = set.get(j).getDom();
                    if (dom < val) {
                        if (i_add) {
                            l.add(new Tuple4Edge(dom, t.getRng()));
                            break;
                        }
                        --j;
                        break;
                    }
                    if (dom == val) {
                        i_add = false;
                    }
                    ++j;
                }
                if (j < setCount) continue;
                if (!i_add) {
                    ++i;
                    while (i < count && (dom = (t = list.get(i)).getDom()) == val) {
                        ++i;
                    }
                }
                while (i < count) {
                    t = list.get(i);
                    l.add(new Tuple4Edge(t.getDom(), t.getRng()));
                    ++i;
                }
                break;
            }
            TupleList tmp = new TupleList(l.size());
            RadixSorter.sort(l, 1, tmp);
            count = l.size();
            l.clear();
            j = 0;
            for (i = 0; i < count; ++i) {
                i_add = true;
                t = tmp.get(i);
                int rng = t.getRng();
                while (j < setCount) {
                    val = set.get(j).getDom();
                    if (rng < val) {
                        if (i_add) {
                            l.add(new Tuple4Edge(t.getDom(), rng));
                            break;
                        }
                        --j;
                        break;
                    }
                    if (rng == val) {
                        i_add = false;
                    }
                    ++j;
                }
                if (j < setCount) continue;
                if (!i_add) {
                    ++i;
                    while (i < count && (rng = (t = tmp.get(i)).getRng()) == val) {
                        ++i;
                    }
                }
                while (i < count) {
                    t = tmp.get(i);
                    l.add(new Tuple4Edge(t.getDom(), t.getRng()));
                    ++i;
                }
                break;
            }
        }
        return l;
    }
}

