/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;

class OperationDegree {
    OperationDegree() {
    }

    static TupleList degree(TupleList list, int col) {
        int count = list.size();
        TupleList l = new TupleList();
        if (count > 0) {
            int deg = 1;
            int elem = list.get(0).get(col);
            for (int i = 1; i < count; ++i) {
                int next = list.get(i).get(col);
                if (elem == next) {
                    ++deg;
                    continue;
                }
                l.add(new Tuple4Edge(elem, IDManager.getID("" + deg)));
                deg = 1;
                elem = next;
            }
            l.add(new Tuple4Edge(elem, IDManager.getID("" + deg)));
        }
        return l;
    }

    static TupleList degree(TupleList list, int[] cols) {
        int count = list.size();
        TupleList l = new TupleList();
        if (count > 0) {
            int deg = 1;
            int[] elem = list.get(0).get(cols);
            for (int i = 1; i < count; ++i) {
                int[] next = list.get(i).get(cols);
                boolean equal = true;
                for (int k = 0; k < cols.length; ++k) {
                    if (elem[k] == next[k]) continue;
                    equal = false;
                    break;
                }
                if (equal) {
                    ++deg;
                    continue;
                }
                l.add(new TupleImpl(elem, IDManager.getID("" + deg)));
                deg = 1;
                elem = next;
            }
            l.add(new TupleImpl(elem, IDManager.getID("" + deg)));
        }
        return l;
    }

    static TupleList outdegree(TupleList list, int col) {
        if (list.size() > 0) {
            int[] cols = new int[list.get(0).size() - col];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = col + i;
            }
            TupleList t_l = list.getTupleList(cols);
            t_l.sort();
            t_l.removeDuplicates();
            return OperationDegree.degree(t_l, 0);
        }
        return new TupleList();
    }

    static TupleList indegree(TupleList list, int col) {
        if (list.size() > 0) {
            int[] cols = new int[col + 1];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = col - i;
            }
            TupleList t_l = list.getTupleList(cols);
            t_l.sort();
            t_l.removeDuplicates();
            return OperationDegree.degree(t_l, 0);
        }
        return new TupleList();
    }
}

