/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.Arrays;

class OperationRel {
    OperationRel() {
    }

    static TupleList composition(TupleList l_a, int col_a, TupleList l_b, int col_b) {
        return OperationRel.composition(l_a, col_a, false, l_b, col_b, false);
    }

    static TupleList compositionRel(TupleList l_a, int col_a, TupleList l_b, int col_b) {
        return OperationRel.compositionRel(l_a, col_a, false, l_b, col_b, false);
    }

    static TupleList composition(TupleList l_a, int col_a, boolean sorted_a, TupleList l_b, int col_b, boolean sorted_b) {
        TupleList l_2;
        TupleList l_1;
        int count1 = l_a.size();
        int count2 = l_b.size();
        TupleList l_r = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l_r;
        }
        if (sorted_a) {
            l_1 = l_a;
        } else {
            l_1 = new TupleList(l_a.size());
            RadixSorter.sort(l_a, col_a, l_1);
        }
        if (sorted_b) {
            l_2 = l_b;
        } else {
            l_2 = new TupleList(l_b.size());
            RadixSorter.sort(l_b, col_b, l_2);
        }
        int[] leftcols_a = new int[l_1.get(0).size() - 1];
        for (int c = 0; c < leftcols_a.length; ++c) {
            leftcols_a[c] = c < col_a ? c : c + 1;
        }
        int[] leftcols_b = new int[l_2.get(0).size() - 1];
        for (int c = 0; c < leftcols_b.length; ++c) {
            leftcols_b[c] = c < col_b ? c : c + 1;
        }
        int j = 0;
        block2: for (int i = 0; i < count1; ++i) {
            Tuple t1 = l_1.get(i);
            int v1 = t1.get(col_a);
            while (j < count2) {
                Tuple t2 = l_2.get(j);
                int v2 = t2.get(col_b);
                if (v1 == v2) {
                    Tuple tmp;
                    for (int k = j; k < count2 && v1 == (tmp = l_2.get(k)).get(col_b); ++k) {
                        l_r.add(new TupleImpl(t1.get(leftcols_a), tmp.get(leftcols_b)));
                    }
                    continue block2;
                }
                if (v1 < v2) continue block2;
                ++j;
            }
        }
        return l_r;
    }

    static TupleList compositionRel(TupleList l_a, int col_a, boolean sorted_a, TupleList l_b, int col_b, boolean sorted_b) {
        TupleList l_2;
        TupleList l_1;
        int count1 = l_a.size();
        int count2 = l_b.size();
        TupleList l_r = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l_r;
        }
        if (sorted_a) {
            l_1 = l_a;
        } else {
            l_1 = new TupleList(l_a.size());
            RadixSorter.sort(l_a, col_a, l_1);
        }
        if (sorted_b) {
            l_2 = l_b;
        } else {
            l_2 = new TupleList(l_b.size());
            RadixSorter.sort(l_b, col_b, l_2);
        }
        int[] cols = new int[l_2.get(0).size() - 1];
        for (int c = 0; c < cols.length; ++c) {
            cols[c] = c < col_b ? c : c + 1;
        }
        int j = 0;
        block1: for (int i = 0; i < count1; ++i) {
            Tuple t1 = l_1.get(i);
            int v1 = t1.get(col_a);
            while (j < count2) {
                Tuple t2 = l_2.get(j);
                int v2 = t2.get(col_b);
                if (v1 == v2) {
                    Tuple tmp;
                    for (int k = j; k < count2 && v1 == (tmp = l_2.get(k)).get(col_b); ++k) {
                        l_r.add(new TupleImpl(t1.toArray(), tmp.get(cols)));
                    }
                    continue block1;
                }
                if (v1 < v2) continue block1;
                ++j;
            }
        }
        return l_r;
    }

    static TupleList composition(TupleList l_a, int[] cols_a, boolean sorted_a, TupleList l_b, int[] cols_b, boolean sorted_b) {
        TupleList l_2;
        int k;
        TupleList l_tmp;
        TupleList l_1;
        int count1 = l_a.size();
        int count2 = l_b.size();
        TupleList l_r = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l_r;
        }
        if (cols_a.length != cols_b.length) {
            return l_r;
        }
        if (sorted_a) {
            l_1 = l_a;
        } else {
            l_tmp = l_a;
            l_1 = new TupleList();
            for (k = cols_a.length - 1; k >= 0; --k) {
                RadixSorter.sort(l_tmp, cols_a[k], l_1);
                l_tmp = l_1;
            }
        }
        if (sorted_b) {
            l_2 = l_b;
        } else {
            l_tmp = l_b;
            l_2 = new TupleList();
            for (k = cols_b.length - 1; k >= 0; --k) {
                RadixSorter.sort(l_tmp, cols_b[k], l_2);
                l_tmp = l_2;
            }
        }
        int[] cols_a_clone = (int[])cols_a.clone();
        Arrays.sort(cols_a_clone);
        int[] leftcols_a = new int[l_1.get(0).size() - cols_a.length];
        int index = 0;
        for (int k2 = 0; k2 < l_1.get(0).size(); ++k2) {
            if (Arrays.binarySearch(cols_a_clone, k2) >= 0) continue;
            leftcols_a[index] = k2;
            ++index;
        }
        int[] cols_b_clone = (int[])cols_b.clone();
        Arrays.sort(cols_b_clone);
        int[] leftcols_b = new int[l_2.get(0).size() - cols_b.length];
        index = 0;
        for (int k3 = 0; k3 < l_2.get(0).size(); ++k3) {
            if (Arrays.binarySearch(cols_b_clone, k3) >= 0) continue;
            leftcols_b[index] = k3;
            ++index;
        }
        int j = 0;
        block4: for (int i = 0; i < count1; ++i) {
            Tuple t1 = l_1.get(i);
            TupleImpl t_v1 = new TupleImpl(t1.get(cols_a), false);
            while (j < count2) {
                Tuple t2 = l_2.get(j);
                TupleImpl t_v2 = new TupleImpl(t2.get(cols_b), false);
                int compare = t_v1.compareTo(t_v2);
                if (compare == 0) {
                    Tuple t_tmp;
                    for (int k4 = j; k4 < count2 && t_v1.compareTo(new TupleImpl((t_tmp = l_2.get(k4)).get(cols_b), false)) == 0; ++k4) {
                        if (leftcols_b.length == 0) {
                            l_r.add(new TupleImpl(t1.get(leftcols_a)));
                            continue;
                        }
                        l_r.add(new TupleImpl(t1.get(leftcols_a), t_tmp.get(leftcols_b)));
                    }
                    continue block4;
                }
                if (compare < 0) continue block4;
                ++j;
            }
        }
        return l_r;
    }

    static TupleList compositionRel(TupleList l_a, int[] cols_a, boolean sorted_a, TupleList l_b, int[] cols_b, boolean sorted_b) {
        TupleList l_2;
        int k;
        TupleList l_tmp;
        TupleList l_1;
        int count1 = l_a.size();
        int count2 = l_b.size();
        TupleList l_r = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l_r;
        }
        if (cols_a.length != cols_b.length) {
            return l_r;
        }
        if (sorted_a) {
            l_1 = l_a;
        } else {
            l_tmp = l_a;
            l_1 = new TupleList();
            for (k = cols_a.length - 1; k >= 0; --k) {
                RadixSorter.sort(l_tmp, cols_a[k], l_1);
                l_tmp = l_1;
            }
        }
        if (sorted_b) {
            l_2 = l_b;
        } else {
            l_tmp = l_b;
            l_2 = new TupleList();
            for (k = cols_b.length - 1; k >= 0; --k) {
                RadixSorter.sort(l_tmp, cols_b[k], l_2);
                l_tmp = l_2;
            }
        }
        int[] cols_b_clone = (int[])cols_b.clone();
        Arrays.sort(cols_b_clone);
        int[] cols = new int[l_2.get(0).size() - cols_b.length];
        int index = 0;
        for (int k2 = 0; k2 < l_2.get(0).size(); ++k2) {
            if (Arrays.binarySearch(cols_b_clone, k2) >= 0) continue;
            cols[index] = k2;
            ++index;
        }
        int j = 0;
        block3: for (int i = 0; i < count1; ++i) {
            Tuple t1 = l_1.get(i);
            TupleImpl t_v1 = new TupleImpl(t1.get(cols_a), false);
            while (j < count2) {
                Tuple t2 = l_2.get(j);
                TupleImpl t_v2 = new TupleImpl(t2.get(cols_b), false);
                int compare = t_v1.compareTo(t_v2);
                if (compare == 0) {
                    Tuple t_tmp;
                    for (int k3 = j; k3 < count2 && t_v1.compareTo(new TupleImpl((t_tmp = l_2.get(k3)).get(cols_b), false)) == 0; ++k3) {
                        if (cols.length == 0) {
                            l_r.add(new TupleImpl(t1.toArray()));
                            continue;
                        }
                        l_r.add(new TupleImpl(t1.toArray(), t_tmp.get(cols)));
                    }
                    continue block3;
                }
                if (compare < 0) continue block3;
                ++j;
            }
        }
        return l_r;
    }

    static TupleList forwardProjection(TupleList s_l, TupleList r_l) {
        int i;
        int count1 = s_l.size();
        int count2 = r_l.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        int j = 0;
        int dim = r_l.get(0).size() - 1;
        if (dim == 2) {
            block0: for (i = 0; i < count1; ++i) {
                Tuple t1 = s_l.get(i);
                int v1 = t1.getRng();
                while (j < count2) {
                    Tuple t2 = r_l.get(j);
                    int v2 = t2.getDom();
                    if (v1 == v2) {
                        l.add(new Tuple4Edge(t2.get(1), t2.get(2)));
                    } else if (v1 < v2) continue block0;
                    ++j;
                }
            }
        } else {
            int[] dims = new int[dim];
            for (int k = 0; k < dim; ++k) {
                dims[k] = k + 1;
            }
            while (i < count1) {
                Tuple t1 = s_l.get(i);
                int v1 = t1.getRng();
                while (j < count2) {
                    Tuple t2 = r_l.get(j);
                    int v2 = t2.getDom();
                    if (v1 == v2) {
                        l.add(new TupleImpl(t2.get(dims), false));
                    } else if (v1 < v2) break;
                    ++j;
                }
                ++i;
            }
        }
        l.sort_removeDuplicates();
        return l;
    }

    static TupleList backwardProjection(TupleList r_l, TupleList s_l) {
        int j;
        int count1 = r_l.size();
        int count2 = s_l.size();
        TupleList l = new TupleList();
        if (count1 == 0 || count2 == 0) {
            return l;
        }
        int i = 0;
        int dim = r_l.get(0).size() - 1;
        if (dim == 2) {
            block0: for (j = 0; j < count2; ++j) {
                Tuple t2 = s_l.get(j);
                int v2 = t2.getDom();
                while (i < count1) {
                    Tuple t1 = r_l.get(i);
                    int v1 = t1.getRng();
                    if (v2 == v1) {
                        l.add(new Tuple4Edge(t1.get(0), t1.get(1)));
                    } else if (v2 < v1) continue block0;
                    ++i;
                }
            }
        } else {
            int[] dims = new int[dim];
            for (int k = 0; k < dim; ++k) {
                dims[k] = k;
            }
            while (j < count2) {
                Tuple t2 = s_l.get(j);
                int v2 = t2.getDom();
                while (i < count1) {
                    Tuple t1 = r_l.get(i);
                    int v1 = t1.getRng();
                    if (v2 == v1) {
                        l.add(new TupleImpl(t1.get(dims), false));
                    } else if (v2 < v1) break;
                    ++i;
                }
                ++j;
            }
        }
        l.sort_removeDuplicates();
        return l;
    }
}

