/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.HashSet;

public class Partition {
    HashSet<Integer> hash = new HashSet(1997, 0.75f);
    TupleList tuplist;

    public int countPartitions(EdgeSet rel) {
        if (rel == null) {
            return 0;
        }
        this.hash.clear();
        this.tuplist = null;
        this.setup(rel);
        int numGraphs = this.compute();
        return numGraphs;
    }

    public EdgeSet[] getPartitions(EdgeSet rel) {
        if (rel == null) {
            return new EdgeSet[0];
        }
        this.hash.clear();
        this.tuplist = null;
        this.setup(rel);
        int numGraphs = this.compute();
        EdgeSet[] result = new EdgeSet[numGraphs];
        TupleList[] tlists = new TupleList[numGraphs];
        for (int i = 0; i < numGraphs; ++i) {
            result[i] = new EdgeSet();
            tlists[i] = result[i].data;
        }
        this.collect(tlists);
        return result;
    }

    private void setup(EdgeSet rel) {
        Tuple t;
        int i;
        TupleList t_l = rel.data;
        int size = t_l.size();
        int[] data = new int[4];
        data[2] = -1;
        this.tuplist = new TupleList(size * 2);
        data[3] = 1;
        for (i = 0; i < size; ++i) {
            t = t_l.get(i);
            data[0] = t.getDom();
            data[1] = t.getRng();
            this.tuplist.add(new TupleImpl(data));
        }
        data[3] = 0;
        for (i = 0; i < size; ++i) {
            t = t_l.get(i);
            data[0] = t.getRng();
            data[1] = t.getDom();
            this.tuplist.add(new TupleImpl(data));
        }
        TupleList tmp = new TupleList(size * 2);
        RadixSorter.sort(this.tuplist, 0, tmp);
        this.tuplist = tmp;
    }

    private int compute() {
        int numGraphs = 0;
        int size = this.tuplist.size();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.tuplist.get(i);
            if (t.get(2) >= 0) continue;
            this.reachGraph(t.get(0), numGraphs);
            ++numGraphs;
        }
        return numGraphs;
    }

    private void collect(TupleList[] graphs) {
        int size = this.tuplist.size();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.tuplist.get(i);
            if (t.get(3) != 1) continue;
            graphs[t.get(2)].add(new Tuple4Edge(t.get(0), t.get(1)));
        }
    }

    private void reachGraph(int dom, int graph) {
        Tuple t;
        Integer I = new Integer(dom);
        if (this.hash.contains(I)) {
            return;
        }
        this.hash.add(I);
        int ind = BinarySearch.search(this.tuplist, dom, 0);
        if (ind < 0) {
            return;
        }
        int size = this.tuplist.size();
        for (int i = ind; i < size && (t = this.tuplist.get(i)).get(0) == dom; ++i) {
            t.set(2, graph);
            this.reachGraph(t.get(1), graph);
        }
    }
}

