/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;

public class Path {
    int[] vertices;

    private Path() {
    }

    public Path(int head) {
        this.vertices = new int[1];
        this.vertices[0] = head;
    }

    public Path(int[] vertices) {
        this.vertices = vertices;
    }

    public int head() {
        return this.vertices[0];
    }

    public int tail() {
        return this.vertices[this.length()];
    }

    public int length() {
        return this.vertices.length - 1;
    }

    public int countVertices() {
        return this.vertices.length;
    }

    public Tuple getTuple() {
        return new TupleImpl(this.vertices, false);
    }

    public boolean contains(int v) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] != v) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int count = this.countVertices();
        StringBuffer b = new StringBuffer();
        if (count > 0) {
            for (int i = 0; i < count - 1; ++i) {
                b.append(IDManager.get(this.vertices[i]));
                b.append(" -> ");
            }
            b.append(IDManager.get(this.vertices[count - 1]));
        }
        return b.toString();
    }

    public static Path link(Path p1, Path p2) {
        Path path = new Path();
        path.vertices = new int[p1.countVertices() + p2.countVertices()];
        System.arraycopy(p1.vertices, 0, path.vertices, 0, p1.countVertices());
        System.arraycopy(p2.vertices, 0, path.vertices, p1.countVertices(), p2.countVertices());
        return path;
    }

    public static Path link(int head, Path p) {
        Path path = new Path();
        path.vertices = new int[p.countVertices() + 1];
        path.vertices[0] = head;
        System.arraycopy(p.vertices, 0, path.vertices, 1, p.countVertices());
        return path;
    }

    public static Path link(Path p, int tail) {
        Path path = new Path();
        path.vertices = new int[p.countVertices() + 1];
        System.arraycopy(p.vertices, 0, path.vertices, 0, p.countVertices());
        path.vertices[p.countVertices()] = tail;
        return path;
    }

    public static Path link(int head, int tail) {
        int[] v = new int[]{head, tail};
        return new Path(v);
    }
}

