/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Operation;
import ca.uwaterloo.cs.jgrok.fb.Path;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleCmpSimple;
import ca.uwaterloo.cs.jgrok.fb.TupleComparator;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.ArrayList;

public class PathClosure {
    TupleList tertiary;
    TupleComparator tcmp;

    public PathClosure(EdgeSet eSet) {
        int[] cols = new int[]{0, 2};
        this.tcmp = new TupleCmpSimple(cols);
        this.tertiary = eSet == null ? new TupleList(5) : Operation.pathClosure(eSet.data);
        TupleList tmp = new TupleList(this.tertiary.size());
        RadixSorter.sort(this.tertiary, 2, tmp);
        this.tertiary = new TupleList(this.tertiary.size());
        RadixSorter.sort(tmp, 0, this.tertiary);
    }

    public Path[] getPaths() {
        ArrayList<Path> all = new ArrayList<Path>(this.tertiary.size());
        for (int i = 0; i < this.tertiary.size(); ++i) {
            Tuple t = this.tertiary.get(i);
            all.addAll(this.getPaths(t.get(0), t.get(2)));
        }
        Path[] paths = new Path[all.size()];
        all.toArray(paths);
        return paths;
    }

    public Path[] getPaths(String head, String tail) {
        ArrayList<Path> found = this.getPaths(IDManager.getID(head), IDManager.getID(tail));
        Path[] paths = new Path[found.size()];
        found.toArray(paths);
        return paths;
    }

    private ArrayList<Path> getPaths(int head, int tail) {
        int[] dat = new int[]{head, 0, tail};
        ArrayList<Path> list = new ArrayList<Path>();
        ArrayList<Path> done = new ArrayList<Path>();
        TupleImpl compound = new TupleImpl(dat);
        int ind = this.search(compound);
        if (ind >= 0) {
            Tuple edge;
            for (int i = ind; i < this.tertiary.size() && this.tcmp.compare(compound, edge = this.tertiary.get(i)) == 0; ++i) {
                if (this.isPrimitive(edge)) {
                    done.add(Path.link(edge.getDom(), edge.getRng()));
                    continue;
                }
                list.add(Path.link(edge.getDom(), edge.get(1)));
            }
            this.search(list, done, dat[2]);
            return done;
        }
        return new ArrayList<Path>(0);
    }

    private void search(ArrayList<Path> undone, ArrayList<Path> done, int tail) {
        int[] dat = new int[3];
        dat[1] = 0;
        dat[2] = tail;
        ArrayList<Path> list = new ArrayList<Path>();
        for (int i = 0; i < undone.size(); ++i) {
            Tuple edge;
            Path p = undone.get(i);
            dat[0] = p.tail();
            TupleImpl compound = new TupleImpl(dat);
            int ind = this.search(compound);
            if (ind < 0) continue;
            while (ind < this.tertiary.size() && this.tcmp.compare(compound, edge = this.tertiary.get(ind)) == 0) {
                if (this.isPrimitive(edge)) {
                    done.add(Path.link(p, tail));
                } else if (!p.contains(edge.get(1))) {
                    list.add(Path.link(p, edge.get(1)));
                }
                ++ind;
            }
        }
        if (list.size() > 0) {
            this.search(list, done, tail);
        }
    }

    private boolean isPrimitive(Tuple t) {
        return t.get(1) == 0;
    }

    private int search(Tuple t) {
        return BinarySearch.search(this.tertiary, t, this.tcmp);
    }
}

