/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.Cell;
import ca.uwaterloo.cs.jgrok.fb.Queue;
import ca.uwaterloo.cs.jgrok.fb.RadixItem;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleListMap;
import java.util.Iterator;

public class RadixSorter {
    public static void sort(TupleList list, TupleList result) {
        TupleList t_l;
        int i;
        TupleListMap listMap = new TupleListMap();
        RadixSorter.regroup(list, listMap);
        TupleList[] listArray = listMap.listArray;
        for (i = 0; i < listArray.length; ++i) {
            t_l = listArray[i];
            if (t_l == null) continue;
            RadixSorter.sortAll(t_l, t_l);
        }
        if (list == result) {
            result.clear();
        }
        for (i = 0; i < listArray.length; ++i) {
            t_l = listArray[i];
            if (t_l == null) continue;
            result.addAll(t_l);
        }
    }

    private static void regroup(TupleList list, TupleListMap listMap) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            Tuple t = list.get(i);
            TupleList t_l = listMap.getList(t.size());
            t_l.add(t);
        }
    }

    private static void sortAll(TupleList list, TupleList result) {
        TupleList aList = list;
        int count = list.size();
        if (count > 0) {
            int colCount = list.get(0).size();
            for (int i = colCount - 1; i >= 0; --i) {
                TupleList t_l = new TupleList(count);
                RadixSorter.sort(aList, i, t_l);
                aList = t_l;
            }
        }
        if (list == result) {
            result.setList(aList.getList());
        } else {
            result.addAll(aList);
        }
    }

    public static void sortDom(TupleList list, TupleList result) {
        RadixSorter.sort(list, 0, result);
    }

    public static void sortRng(TupleList list, TupleList result) {
        Queue q = new Queue();
        Queue[] p = new Queue[10];
        int loop = 0;
        int max = RadixSorter.initQueueRng(q, list);
        while (max > 0) {
            max /= 10;
            ++loop;
        }
        int size = list.size();
        for (int j = 0; j < loop; ++j) {
            int i;
            for (i = 0; i < 10; ++i) {
                p[i] = new Queue();
            }
            for (i = 0; i < size; ++i) {
                RadixItem item = q.dequeue();
                int val = item.getValue();
                int last = RadixSorter.getLastDigit(val);
                item.setValue(RadixSorter.getPrefix(val));
                p[last].enqueue(item);
            }
            for (i = 0; i < 10; ++i) {
                q.append(p[i]);
            }
        }
        Cell next = null;
        Cell tail = q.trailer();
        if (tail == null) {
            return;
        }
        if (list == result) {
            result.clear();
        }
        for (next = tail.getNext(); next != tail; next = next.getNext()) {
            result.add(next.getItem().getTuple());
        }
        result.add(tail.getItem().getTuple());
    }

    public static void sort(TupleList list, int col, TupleList result) {
        Queue q = new Queue();
        Queue[] p = new Queue[10];
        int loop = 0;
        int max = RadixSorter.initQueue(q, list, col);
        while (max > 0) {
            max /= 10;
            ++loop;
        }
        int size = list.size();
        for (int j = 0; j < loop; ++j) {
            int i;
            for (i = 0; i < 10; ++i) {
                p[i] = new Queue();
            }
            for (i = 0; i < size; ++i) {
                RadixItem item = q.dequeue();
                int val = item.getValue();
                int last = RadixSorter.getLastDigit(val);
                item.setValue(RadixSorter.getPrefix(val));
                p[last].enqueue(item);
            }
            for (i = 0; i < 10; ++i) {
                q.append(p[i]);
            }
        }
        Cell next = null;
        Cell tail = q.trailer();
        if (tail == null) {
            return;
        }
        if (list == result) {
            result.clear();
        }
        for (next = tail.getNext(); next != tail; next = next.getNext()) {
            result.add(next.getItem().getTuple());
        }
        result.add(tail.getItem().getTuple());
    }

    static int getPrefix(int val) {
        return val / 10;
    }

    static int getLastDigit(int val) {
        return val % 10;
    }

    static int initQueue(Queue queue, TupleList list, int col) {
        int maxNum = 0;
        Iterator<Tuple> iter = list.iterator();
        while (iter.hasNext()) {
            Tuple t = iter.next();
            int val = col < t.size() ? t.get(col) : 0;
            if (val > maxNum) {
                maxNum = val;
            }
            queue.enqueue(new RadixItem(val, t));
        }
        return maxNum;
    }

    static int initQueueRng(Queue queue, TupleList list) {
        int maxNum = 0;
        Iterator<Tuple> iter = list.iterator();
        while (iter.hasNext()) {
            Tuple t = iter.next();
            int val = t.getRng();
            if (val > maxNum) {
                maxNum = val;
            }
            queue.enqueue(new RadixItem(val, t));
        }
        return maxNum;
    }
}

