/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.Column;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Header;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.OperationRel;
import ca.uwaterloo.cs.jgrok.fb.TupleFactory;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleSelectorSimple;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.fb.UnknownColumnException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class Relation {
    protected Header header;
    protected TupleSet body;
    protected boolean reduce = true;

    public Relation(Header header, TupleSet inputData) {
        this.header = header;
        this.init(inputData);
    }

    public Relation(Header header, TupleSet inputData, boolean reduce) {
        this.header = header;
        this.reduce = reduce;
        this.init(inputData);
    }

    private void init(TupleSet inputData) {
        int[] indexes = new int[this.header.size()];
        int i = 0;
        int j = 0;
        int dims = 0;
        for (i = 0; i < this.header.size(); ++i) {
            if (this.header.get(i).getName().equals("_")) {
                indexes[i] = -1;
                continue;
            }
            ++dims;
            indexes[i] = i;
        }
        int[] indexes2 = new int[dims];
        Column[] cols = new Column[dims];
        i = 0;
        j = 0;
        for (i = 0; i < indexes2.length; ++i) {
            while (j < indexes.length && indexes[j] <= -1) {
                ++j;
            }
            cols[i] = this.header.get(j);
            indexes2[i] = indexes[j];
            ++j;
        }
        this.header = new Header(cols);
        TupleList tList = inputData.getTupleList();
        tList = tList.getTupleList(indexes2);
        for (i = 0; i < dims; ++i) {
            for (j = i + 1; j < dims; ++j) {
                if (!this.header.get(i).equals(this.header.get(j))) continue;
                TupleSelectorSimple selector = new TupleSelectorSimple(i, j);
                tList = tList.select(selector);
            }
        }
        if (this.reduce) {
            HashMap<Integer, Column> map = new HashMap<Integer, Column>(3);
            for (i = 0; i < this.header.size(); ++i) {
                Column col = this.header.get(i);
                String key = col.getName();
                if (map.containsKey(key)) continue;
                map.put(new Integer(i), col);
            }
            if (map.size() < dims) {
                i = 0;
                dims = map.size();
                int[] choose = new int[dims];
                Iterator itr = map.keySet().iterator();
                while (itr.hasNext()) {
                    choose[i] = (Integer)itr.next();
                    ++i;
                }
                Arrays.sort(choose);
                cols = new Column[choose.length];
                for (i = 0; i < choose.length; ++i) {
                    cols[i] = (Column)map.get(new Integer(choose[i]));
                }
                this.header = new Header(cols);
                TupleList tmp = new TupleList(tList.size());
                for (i = 0; i < tList.size(); ++i) {
                    tmp.add(TupleFactory.create(tList.get(i).get(choose), false));
                }
                tList = tmp;
            }
        }
        this.body = dims == 1 ? new NodeSet() : (dims == 2 ? new EdgeSet() : new TupleSet());
        this.body.data = tList;
        this.body.removeDuplicates();
    }

    public Header getHeader() {
        return this.header;
    }

    public TupleSet getBody() {
        return this.body;
    }

    public int[] getHeaderIndexes(Header h) {
        int i;
        int[] indexes = new int[h.size()];
        for (i = 0; i < indexes.length; ++i) {
            indexes[i] = -1;
        }
        for (i = 0; i < indexes.length; ++i) {
            for (int j = 0; j < this.header.size(); ++j) {
                if (!h.get(i).equals(this.header.get(j))) continue;
                indexes[i] = j;
            }
        }
        return indexes;
    }

    public static Relation project(Relation R, Header h) throws UnknownColumnException {
        int[] indexes = R.getHeaderIndexes(h);
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0) continue;
            throw new UnknownColumnException(h.get(i));
        }
        TupleList tList = R.getBody().getTupleList().getTupleList(indexes);
        TupleSet newBody = new TupleSet();
        newBody.data = tList;
        return new Relation(h, newBody);
    }

    public static Relation compose(Relation R1, Relation R2, Header h) {
        int i;
        int[] indexes1 = R1.getHeaderIndexes(h);
        int[] indexes2 = R2.getHeaderIndexes(h);
        TupleList tList = OperationRel.compositionRel(R1.getBody().getTupleList(), indexes1, false, R2.getBody().getTupleList(), indexes2, false);
        int dims = R1.getHeader().size() + R2.getHeader().size() - h.size();
        Column[] cols = new Column[dims];
        for (i = 0; i < R1.getHeader().size(); ++i) {
            cols[i] = R1.getHeader().get(i);
        }
        int j = 0;
        while (i < cols.length) {
            while (j < R2.getHeader().size() && h.contains(R2.getHeader().get(j))) {
                ++j;
            }
            cols[i] = R2.getHeader().get(j);
            ++j;
            ++i;
        }
        Header newHeader = new Header(cols);
        TupleSet newBody = new TupleSet();
        newBody.data = tList;
        return new Relation(newHeader, newBody);
    }
}

