/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.ArrayList;

public class ShowDB {
    TupleList shadow;
    TupleList attList;
    TupleList relList;
    TupleList nameList;
    StringBuffer buffer;
    int name_ID = IDManager.getID("@name");
    int inst_ID = IDManager.getID("$INSTANCE");

    public ShowDB() {
        this.buffer = new StringBuffer();
        this.attList = new TupleList(1000);
        this.relList = new TupleList(1000);
    }

    public void addRels(EdgeSet eSet) {
        TupleList t_l = eSet.data;
        int size = t_l.size();
        int[] data = new int[3];
        data[0] = IDManager.getID(eSet.getName());
        for (int i = 0; i < size; ++i) {
            Tuple t = t_l.get(i);
            data[1] = t.getDom();
            data[2] = t.getRng();
            TupleImpl t3 = new TupleImpl(data);
            this.relList.add(t3);
        }
    }

    public void addAtts(EdgeSet eSet) {
        TupleList t_l = eSet.data;
        int size = t_l.size();
        int[] data = new int[3];
        data[0] = IDManager.getID(eSet.getName());
        if (data[0] == this.name_ID) {
            this.nameList = (TupleList)t_l.clone();
        }
        for (int i = 0; i < size; ++i) {
            Tuple t = t_l.get(i);
            data[1] = t.getDom();
            data[2] = t.getRng();
            TupleImpl t3 = new TupleImpl(data);
            this.attList.add(t3);
        }
    }

    public void setup() {
        TupleList t_l;
        if (this.nameList != null) {
            t_l = new TupleList(this.nameList.size());
            RadixSorter.sort(this.nameList, 0, t_l);
            this.nameList = t_l;
        }
        t_l = new TupleList(this.attList.size());
        RadixSorter.sort(this.attList, 0, t_l);
        this.attList = new TupleList(t_l.size());
        RadixSorter.sort(t_l, 1, this.attList);
        t_l = new TupleList(this.relList.size());
        RadixSorter.sort(this.relList, 0, t_l);
        this.relList = new TupleList(t_l.size());
        RadixSorter.sort(t_l, 1, this.relList);
        this.shadow = new TupleList(t_l.size());
        RadixSorter.sort(t_l, 2, this.shadow);
    }

    public String getName(int nodeID) {
        if (this.nameList == null) {
            return null;
        }
        int ind = BinarySearch.search(this.nameList, nodeID, 0);
        if (ind < 0) {
            return null;
        }
        return IDManager.get(this.nameList.get(ind).get(1));
    }

    public String[] getAtts(int nodeID) {
        Tuple t;
        String[] result = new String[]{null, null, null};
        int ind = BinarySearch.search(this.attList, nodeID, 1);
        if (ind < 0) {
            return result;
        }
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append("{ ");
        while (ind < this.attList.size() && (t = this.attList.get(ind)).get(1) == nodeID) {
            int t0 = t.get(0);
            if (t0 == this.name_ID) {
                result[0] = IDManager.get(t.get(2));
            } else if (t0 == this.inst_ID) {
                result[1] = IDManager.get(t.get(2));
            } else {
                this.buffer.append(IDManager.get(t0).substring(1));
                this.buffer.append('=');
                this.buffer.append(IDManager.get(t.get(2)));
                this.buffer.append(' ');
            }
            ++ind;
        }
        if (this.buffer.length() > 2) {
            this.buffer.append("}");
            result[2] = this.buffer.toString();
        }
        return result;
    }

    public ArrayList<String> getRels(int nodeID) {
        String name;
        Tuple t;
        int count;
        ArrayList<String> result = new ArrayList<String>();
        int ind = BinarySearch.search(this.relList, nodeID, 1);
        if (ind >= 0) {
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append("( ");
            count = this.relList.size();
            while (ind < count && (t = this.relList.get(ind)).get(1) == nodeID) {
                this.buffer.delete(2, this.buffer.length());
                this.buffer.append(IDManager.get(t.get(0)));
                this.buffer.append(" -> ");
                name = this.getName(t.get(2));
                if (name != null) {
                    this.buffer.append(name);
                    this.buffer.append(" @ ");
                }
                this.buffer.append(IDManager.get(t.get(2)));
                this.buffer.append(" )");
                result.add(this.buffer.toString());
                ++ind;
            }
        }
        if ((ind = BinarySearch.search(this.shadow, nodeID, 2)) >= 0) {
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append("( ");
            count = this.shadow.size();
            while (ind < count && (t = this.shadow.get(ind)).get(2) == nodeID) {
                this.buffer.delete(2, this.buffer.length());
                this.buffer.append(IDManager.get(t.get(0)));
                this.buffer.append(" <- ");
                name = this.getName(t.get(1));
                if (name != null) {
                    this.buffer.append(name);
                    this.buffer.append(" @ ");
                }
                this.buffer.append(IDManager.get(t.get(1)));
                this.buffer.append(" )");
                result.add(this.buffer.toString());
                ++ind;
            }
        }
        return result;
    }

    public static String getAtt(int nodeID, EdgeSet eSet) {
        if (eSet == null) {
            return null;
        }
        eSet.trySort(0);
        TupleList t_l = eSet.data;
        int ind = BinarySearch.search(t_l, nodeID, 0);
        if (ind < 0) {
            return null;
        }
        return IDManager.get(t_l.get(ind).get(1));
    }

    public static ArrayList<String> getRels(int nodeID, EdgeSet eSet, EdgeSet attName) {
        String name;
        Tuple t;
        int count;
        int len;
        ArrayList<String> result = new ArrayList<String>();
        TupleList rngList = eSet.shadow();
        if (eSet.sortLevel % 2 != 0) {
            TupleList t_l = new TupleList(eSet.size());
            RadixSorter.sort(rngList, 0, t_l);
            eSet.data = t_l;
            eSet.sortLevel = 2;
        }
        TupleList domList = eSet.data;
        StringBuffer buffer = new StringBuffer();
        buffer.append("( ");
        buffer.append(eSet.getName());
        int constLen = buffer.length();
        int ind = BinarySearch.search(domList, nodeID, 0);
        if (ind >= 0) {
            int prev;
            buffer.append(" -> ");
            len = buffer.length();
            while (ind > 0 && domList.get(prev = ind - 1).get(0) == nodeID) {
                ind = prev;
            }
            count = domList.size();
            while (ind < count && (t = domList.get(ind)).get(0) == nodeID) {
                buffer.delete(len, buffer.length());
                name = ShowDB.getAtt(t.get(1), attName);
                if (name != null) {
                    buffer.append(name);
                    buffer.append(" @ ");
                }
                buffer.append(IDManager.get(t.get(1)));
                buffer.append(" )");
                result.add(buffer.toString());
                ++ind;
            }
        }
        if ((ind = BinarySearch.search(rngList, nodeID, 1)) >= 0) {
            buffer.delete(constLen, buffer.length());
            buffer.append(" <- ");
            len = buffer.length();
            count = rngList.size();
            while (ind < count && (t = rngList.get(ind)).get(1) == nodeID) {
                buffer.delete(len, buffer.length());
                name = ShowDB.getAtt(t.get(0), attName);
                if (name != null) {
                    buffer.append(name);
                    buffer.append(" @ ");
                }
                buffer.append(IDManager.get(t.get(0)));
                buffer.append(" )");
                result.add(buffer.toString());
                ++ind;
            }
        }
        return result;
    }
}

