/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.Operation;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Node;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.StringTokenizer;

public class SpecialOperation {
    public static int encode(NodeSet nSet) {
        nSet.trySort(0);
        return SpecialOperation.encodeID(nSet.data);
    }

    public static NodeSet decode(int setID) {
        NodeSet nSet = new NodeSet();
        nSet.data = SpecialOperation.decodeID(setID);
        nSet.sortLevel = 0;
        return nSet;
    }

    public static NodeSet basket(String exp) {
        NodeSet result = null;
        if (exp.length() > 0 && exp.charAt(0) == '(' && exp.charAt(exp.length() - 1) == ')') {
            String s = exp.substring(1, exp.length() - 1);
            StringTokenizer st = new StringTokenizer(s);
            NodeSet tokenSet = new NodeSet();
            while (st.hasMoreTokens()) {
                tokenSet.add(st.nextToken());
            }
            if (tokenSet.size() > 0) {
                result = NodeSet.singleton(SpecialOperation.encode(tokenSet));
            }
        }
        if (result == null) {
            result = new NodeSet();
        }
        return result;
    }

    public static NodeSet basket(NodeSet set) {
        NodeSet result;
        if (set.size() > 0) {
            result = NodeSet.singleton(SpecialOperation.encode(set));
            result.sortLevel = 0;
        } else {
            result = new NodeSet();
        }
        result.setHasDuplicates(false);
        return result;
    }

    public static EdgeSet basket(EdgeSet eSet) {
        EdgeSet result = new EdgeSet();
        eSet.trySort(0);
        result.data = SpecialOperation.basket(eSet.data);
        result.setHasDuplicates(false);
        result.sortLevel = 0;
        return result;
    }

    public static NodeSet unbasket(String exp) {
        NodeSet result = new NodeSet();
        if (exp.length() > 0 && exp.charAt(0) == '(' && exp.charAt(exp.length() - 1) == ')') {
            String s = exp.substring(1, exp.length() - 1);
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result;
    }

    public static NodeSet unbasket(NodeSet set) {
        NodeSet result = new NodeSet();
        TupleList t_l = set.data;
        for (int i = 0; i < t_l.size(); ++i) {
            int id = t_l.get(i).getDom();
            int[] ids = IDManager.parse(id);
            for (int j = 0; j < ids.length; ++j) {
                result.add(ids[j]);
            }
        }
        return result;
    }

    public static EdgeSet unbasket(EdgeSet eSet) {
        EdgeSet result = new EdgeSet();
        TupleList t_l = eSet.data;
        for (int i = 0; i < t_l.size(); ++i) {
            Tuple t = t_l.get(i);
            int dom = t.getDom();
            int rng = t.getRng();
            int[] ids = IDManager.parse(rng);
            for (int j = 0; j < ids.length; ++j) {
                result.add(dom, ids[j]);
            }
        }
        return result;
    }

    public static EdgeSet lattice(NodeSet nSet) {
        EdgeSet result = new EdgeSet();
        TupleList t_l = nSet.data;
        int count = t_l.size();
        for (int i = 0; i < count - 1; ++i) {
            int currID = t_l.get(i).getDom();
            NodeSet curr = SpecialOperation.decode(currID);
            for (int j = i + 1; j < count; ++j) {
                int compID = t_l.get(j).getDom();
                NodeSet comp = SpecialOperation.decode(compID);
                int val = Operation.comparison(curr.data, comp.data);
                if (val == -1) {
                    result.data.add(new Tuple4Edge(compID, currID));
                    continue;
                }
                if (val != 1) continue;
                result.data.add(new Tuple4Edge(currID, compID));
            }
        }
        return AlgebraOperation.unclosure(result);
    }

    static int encodeID(TupleList setL) {
        int count = setL.size();
        if (count > 0) {
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = setL.get(i).getDom();
            }
            return IDManager.getID(ids);
        }
        return 0;
    }

    static TupleList decodeID(int setID) {
        int[] ids = IDManager.parse(setID);
        TupleList t_l = new TupleList(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            t_l.add(new Tuple4Node(ids[i]));
        }
        return t_l;
    }

    static TupleList basket(TupleList list) {
        int count = list.size();
        TupleList l = new TupleList();
        TupleList v = new TupleList();
        if (count > 0) {
            Tuple t = list.get(0);
            int curr = t.getDom();
            v.add(new Tuple4Node(t.getRng()));
            for (int i = 1; i < count; ++i) {
                t = list.get(i);
                int next = t.getDom();
                if (curr == next) {
                    v.add(new Tuple4Node(t.getRng()));
                    continue;
                }
                RadixSorter.sort(v, 0, v);
                l.add(new Tuple4Edge(curr, SpecialOperation.encodeID(v)));
                v.clear();
                curr = next;
                v.add(new Tuple4Node(t.getRng()));
            }
            RadixSorter.sort(v, 0, v);
            l.add(new Tuple4Edge(curr, SpecialOperation.encodeID(v)));
        }
        return l;
    }
}

