/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Node;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.ArrayList;
import java.util.HashMap;

class StringTable {
    private static int s_index = 0;
    private static StringTable instance = new StringTable(100003);
    private ArrayList<StringCell> cellList;
    private HashMap<String, StringCell> allStrings;

    static StringTable instance() {
        return instance;
    }

    private StringTable(int initialCapacity) {
        this.cellList = new ArrayList(initialCapacity);
        this.allStrings = new HashMap(initialCapacity, 0.75f);
        this.add(null);
    }

    int size() {
        return this.cellList.size();
    }

    int add(String data) {
        StringCell cell = this.allStrings.get(data);
        if (cell != null) {
            return cell.index;
        }
        cell = new StringCell(s_index, data);
        this.cellList.add(s_index, cell);
        this.allStrings.put(data, cell);
        ++s_index;
        return cell.index;
    }

    int addComposite(String data) {
        StringCell cell = this.allStrings.get(data);
        if (cell != null) {
            return cell.index;
        }
        cell = new StringCell(s_index, data);
        cell.setComposite(true);
        this.cellList.add(s_index, cell);
        this.allStrings.put(data, cell);
        ++s_index;
        return cell.index;
    }

    String get(int index) {
        StringCell cell = this.cellList.get(index);
        return cell.data;
    }

    int getReplace(int index) {
        StringCell cell = this.cellList.get(index);
        return cell.replace;
    }

    void setReplace(int index, int replace) {
        StringCell cell = this.cellList.get(index);
        cell.replace = replace;
    }

    void initReplace(TupleList pairIDs) {
        int count = pairIDs.size();
        for (int i = 0; i < count; ++i) {
            Tuple t = pairIDs.get(i);
            this.setReplace(t.getDom(), t.getRng());
        }
    }

    void closeReplace() {
        for (int i = 0; i < s_index; ++i) {
            this.setReplace(i, i);
        }
    }

    boolean isComposite(int index) {
        StringCell cell = this.cellList.get(index);
        return cell.isComposite();
    }

    TupleList getID() {
        TupleList t_l = new TupleList(s_index);
        for (int i = 1; i < s_index; ++i) {
            t_l.add(new Tuple4Edge(i, i));
        }
        return t_l;
    }

    TupleList getENT() {
        TupleList t_l = new TupleList(s_index);
        for (int i = 1; i < s_index; ++i) {
            t_l.add(new Tuple4Node(i));
        }
        return t_l;
    }

    TupleList getAllComposites() {
        TupleList t_l = new TupleList();
        for (int i = 0; i < s_index; ++i) {
            if (!this.isComposite(i)) continue;
            t_l.add(new Tuple4Node(i));
        }
        return t_l;
    }

    private static class StringCell {
        int flag = 0;
        int index = 0;
        int replace = 0;
        String data = null;
        static final int FLAG_COMPOSITE = 1;

        StringCell(int index, String data) {
            this.data = data;
            this.index = index;
            this.replace = index;
        }

        boolean isComposite() {
            return 1 == (this.flag & 1);
        }

        void setComposite(boolean b) {
            this.flag |= 1;
        }
    }
}

