/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.ArrayList;
import java.util.HashMap;

public class Tree {
    private int[] theRoots;
    private TupleList tlist;
    private MiniTable table;

    public Tree(EdgeSet eSet) {
        eSet.trySort(0);
        this.tlist = eSet.data;
        this.table = new MiniTable();
        this.init();
    }

    private void init() {
        int size = this.tlist.size();
        for (int i = 0; i < size; ++i) {
            Tuple tup = this.tlist.get(i);
            int dom = tup.getDom();
            int rng = tup.getRng();
            Entry entry = this.table.putNode(dom);
            if (entry.outIndex == -1) {
                entry.outIndex = i;
            }
            entry = this.table.putNode(rng);
            entry.parent = dom;
        }
    }

    public int[] getRoots() {
        Entry entry;
        int i;
        if (this.theRoots != null) {
            return (int[])this.theRoots.clone();
        }
        ArrayList<Entry> entryList = this.table.entryList;
        ArrayList<Entry> rootEntries = new ArrayList<Entry>(2);
        int count = entryList.size();
        for (i = 0; i < count; ++i) {
            entry = entryList.get(i);
            if (entry.parent != -1) continue;
            rootEntries.add(entry);
        }
        count = rootEntries.size();
        this.theRoots = new int[count];
        for (i = 0; i < count; ++i) {
            entry = (Entry)rootEntries.get(i);
            this.theRoots[i] = entry.node;
        }
        return (int[])this.theRoots.clone();
    }

    public int getParent(int child) {
        Entry entry = this.table.getNode(child);
        if (entry == null) {
            return -1;
        }
        return entry.parent;
    }

    public int[] getChildren(int parent) {
        Tuple tup;
        int dom = parent;
        Entry entry = this.table.getNode(dom);
        if (entry == null) {
            return new int[0];
        }
        if (entry.outIndex == -1) {
            return new int[0];
        }
        int size = this.tlist.size();
        ArrayList<Tuple> childList = new ArrayList<Tuple>(5);
        for (int i = entry.outIndex; i < size && (tup = this.tlist.get(i)).getDom() == dom; ++i) {
            childList.add(tup);
        }
        int count = childList.size();
        int[] children = new int[count];
        for (int i = 0; i < count; ++i) {
            tup = (Tuple)childList.get(i);
            children[i] = tup.getRng();
        }
        return children;
    }

    public EdgeSet getLevelRelation() {
        EdgeSet l = new EdgeSet();
        ArrayList<Entry> list = this.table.entryList;
        this.setLevels();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Entry e = list.get(i);
            l.add(e.node, IDManager.getID(e.level + ""));
        }
        return l;
    }

    void setRoot(int root) {
        this.theRoots = new int[1];
        this.theRoots[0] = root;
    }

    void setLevels() {
        int[] roots = this.getRoots();
        if (roots.length == 1) {
            this.setLevel(roots[0], 0);
        }
    }

    void setLevel(int node, int level) {
        Entry entry = this.table.getNode(node);
        entry.level = level;
        int[] children = this.getChildren(node);
        for (int i = 0; i < children.length; ++i) {
            this.setLevel(children[i], level + 1);
        }
    }

    Entry getEntry(int node) {
        return this.table.getNode(node);
    }

    static class Entry {
        int node;
        int level = -1;
        int parent = -1;
        int outIndex = -1;

        Entry(int node) {
            this.node = node;
        }
    }

    static class MiniTable {
        int s_index = 0;
        ArrayList<Entry> entryList = new ArrayList(1997);
        HashMap<String, Entry> allStrings = new HashMap(1997, 0.75f);

        MiniTable() {
        }

        Entry putNode(int node) {
            String name = node + "";
            Entry entry = this.allStrings.get(name);
            if (entry != null) {
                return entry;
            }
            entry = new Entry(node);
            this.entryList.add(this.s_index, entry);
            this.allStrings.put(name, entry);
            ++this.s_index;
            return entry;
        }

        Entry getNode(int node) {
            String name = node + "";
            return this.allStrings.get(name);
        }
    }
}

