/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.Tree;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.UtilityOperation;

public class Tree2 {
    EdgeSet contain;
    EdgeSet edgeContain;
    private Tree nodeTree;

    public Tree2(EdgeSet contain) {
        this.contain = contain;
    }

    private void init(EdgeSet myContain) {
        this.edgeContain = new EdgeSet();
        this.nodeTree = new Tree(myContain);
        this.nodeTree.setLevels();
    }

    private void setupCompoundEdges(int top, boolean fake, EdgeSet edges, boolean compound) {
        EdgeSet newEdges = new EdgeSet();
        newEdges.setName(edges.getName());
        Tree.Entry topEntry = this.nodeTree.getEntry(top);
        int edgeType = IDManager.getID(edges.getName());
        TupleList tlist = edges.data;
        int count = tlist.size();
        for (int i = 0; i < count; ++i) {
            int parentEdge;
            Tuple t = tlist.get(i);
            int dom = t.getDom();
            int rng = t.getRng();
            int domParent = this.nodeTree.getParent(dom);
            int rngParent = this.nodeTree.getParent(rng);
            if (domParent < 0 || rngParent < 0) continue;
            Tree.Entry domParentEntry = this.nodeTree.getEntry(domParent);
            Tree.Entry rngParentEntry = this.nodeTree.getEntry(rngParent);
            int childEdge = compound ? IDManager.getID(edgeType, dom, rng) : IDManager.getID(dom, rng);
            if (domParentEntry.level > topEntry.level && rngParentEntry.level > topEntry.level) {
                if (domParent != rngParent) {
                    int nodeParent;
                    int node;
                    int currentEdge;
                    int j;
                    boolean levelup = false;
                    if (domParentEntry.level > rngParentEntry.level) {
                        int domAncestor = domParent;
                        for (j = domParentEntry.level - rngParentEntry.level; j > 0; --j) {
                            domAncestor = this.nodeTree.getParent(domAncestor);
                        }
                        if (domAncestor == rngParent) {
                            domAncestor = domParent;
                            currentEdge = childEdge;
                            for (j = domParentEntry.level - rngParentEntry.level; j > 0; --j) {
                                parentEdge = IDManager.getID(edgeType, domAncestor, rng);
                                this.edgeContain.add(parentEdge, currentEdge);
                                currentEdge = parentEdge;
                                domAncestor = this.nodeTree.getParent(domAncestor);
                            }
                            this.edgeContain.add(domAncestor, currentEdge);
                            if (!fake && domAncestor != top) {
                                node = domAncestor;
                                while (node != top) {
                                    nodeParent = this.nodeTree.getParent(node);
                                    this.edgeContain.add(nodeParent, node);
                                    node = nodeParent;
                                }
                            }
                            levelup = true;
                        }
                    } else if (rngParentEntry.level > domParentEntry.level) {
                        int rngAncestor = rngParent;
                        for (j = rngParentEntry.level - domParentEntry.level; j > 0; --j) {
                            rngAncestor = this.nodeTree.getParent(rngAncestor);
                        }
                        if (rngAncestor == domParent) {
                            rngAncestor = rngParent;
                            currentEdge = childEdge;
                            for (j = rngParentEntry.level - domParentEntry.level; j > 0; --j) {
                                parentEdge = IDManager.getID(edgeType, dom, rngAncestor);
                                this.edgeContain.add(parentEdge, currentEdge);
                                currentEdge = parentEdge;
                                rngAncestor = this.nodeTree.getParent(rngAncestor);
                            }
                            this.edgeContain.add(rngAncestor, currentEdge);
                            if (!fake && rngAncestor != top) {
                                node = rngAncestor;
                                while (node != top) {
                                    nodeParent = this.nodeTree.getParent(node);
                                    this.edgeContain.add(nodeParent, node);
                                    node = nodeParent;
                                }
                            }
                            levelup = true;
                        }
                    }
                    if (levelup) continue;
                    newEdges.add(domParent, rngParent);
                    parentEdge = IDManager.getID(edgeType, domParent, rngParent);
                    this.edgeContain.add(parentEdge, childEdge);
                    continue;
                }
                this.edgeContain.add(domParent, childEdge);
                if (fake || domParent == top) continue;
                int node = domParent;
                while (node != top) {
                    int nodeParent = this.nodeTree.getParent(node);
                    this.edgeContain.add(nodeParent, node);
                    node = nodeParent;
                }
                continue;
            }
            if (domParentEntry.level > topEntry.level) {
                if (rngParent != top) continue;
                newEdges.add(domParent, rng);
                parentEdge = IDManager.getID(edgeType, domParent, rng);
                this.edgeContain.add(parentEdge, childEdge);
                continue;
            }
            if (rngParentEntry.level > topEntry.level) {
                if (domParent != top) continue;
                newEdges.add(dom, rngParent);
                parentEdge = IDManager.getID(edgeType, dom, rngParent);
                this.edgeContain.add(parentEdge, childEdge);
                continue;
            }
            if (domParent != top || rngParent != top) continue;
            this.edgeContain.add(top, childEdge);
        }
        if (newEdges.size() > 0) {
            this.setupCompoundEdges(top, fake, newEdges, true);
        }
    }

    public Tree getEdgeTree(int top, EdgeSet primitiveEdges) {
        EdgeSet Do = AlgebraOperation.reflectiveClosure(this.contain);
        NodeSet useSet = AlgebraOperation.project(NodeSet.singleton(top), Do);
        NodeSet entSet = AlgebraOperation.entityOf(this.contain);
        NodeSet delSet = AlgebraOperation.difference(entSet, useSet);
        EdgeSet usefulEdges = UtilityOperation.delset(primitiveEdges, delSet);
        usefulEdges.setName(primitiveEdges.getName());
        EdgeSet myContain = UtilityOperation.delset(this.contain, delSet);
        this.init(myContain);
        this.setupCompoundEdges(top, false, usefulEdges, false);
        this.edgeContain.removeDuplicates();
        Tree tree = new Tree(this.edgeContain);
        tree.setRoot(top);
        return tree;
    }

    public Tree getEdgeTree(int src, int trg, EdgeSet primitiveEdges) {
        NodeSet roots = new NodeSet();
        roots.add(src);
        roots.add(trg);
        EdgeSet subtree = UtilityOperation.subtree(roots, this.contain);
        NodeSet entSet = AlgebraOperation.entityOf(this.contain);
        NodeSet useSet = AlgebraOperation.entityOf(subtree);
        NodeSet delSet = AlgebraOperation.difference(entSet, useSet);
        EdgeSet usefulEdges = UtilityOperation.delset(primitiveEdges, delSet);
        usefulEdges.setName(primitiveEdges.getName());
        EdgeSet myContain = subtree;
        int top = IDManager.getID(0, 0, 0);
        myContain.add(top, src);
        myContain.add(top, trg);
        this.init(myContain);
        this.setupCompoundEdges(top, true, usefulEdges, false);
        this.edgeContain.removeDuplicates();
        Tree tree = new Tree(this.edgeContain);
        tree.setRoot(top);
        return tree;
    }

    public Tree getEdgeTree(EdgeSet primitiveEdges) {
        int top;
        boolean fake;
        NodeSet dom = AlgebraOperation.domainOf(this.contain);
        NodeSet rng = AlgebraOperation.rangeOf(this.contain);
        NodeSet ent = AlgebraOperation.entityOf(this.contain);
        NodeSet source = AlgebraOperation.difference(dom, rng);
        if (source.size() == 0) {
            return new Tree(new EdgeSet());
        }
        EdgeSet usefulEdges = AlgebraOperation.composition(ent, primitiveEdges);
        usefulEdges = AlgebraOperation.composition(usefulEdges, ent);
        usefulEdges.setName(primitiveEdges.getName());
        EdgeSet myContain = this.contain;
        if (source.size() > 1) {
            fake = true;
            top = IDManager.getID(0, 0, 0);
            myContain = AlgebraOperation.crossProduct(NodeSet.singleton(top), source);
            myContain = AlgebraOperation.union(this.contain, myContain);
        } else {
            fake = false;
            top = source.getTupleList().get(0).getDom();
        }
        this.init(myContain);
        this.setupCompoundEdges(top, fake, usefulEdges, false);
        this.edgeContain.removeDuplicates();
        Tree tree = new Tree(this.edgeContain);
        tree.setRoot(top);
        return tree;
    }
}

