/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Node;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleSelector;
import java.util.ArrayList;
import java.util.Iterator;

public class TupleList
implements Cloneable {
    private ArrayList<Tuple> listBody;

    public TupleList() {
        this.listBody = new ArrayList();
    }

    public TupleList(int initialCapacity) {
        this.listBody = new ArrayList(initialCapacity);
    }

    public Tuple get(int ind) {
        return this.listBody.get(ind);
    }

    public void add(Tuple t) {
        this.listBody.add(t);
    }

    public void addAll(TupleList list) {
        this.listBody.addAll(list.getList());
    }

    public int size() {
        return this.listBody.size();
    }

    public void clear() {
        this.listBody = new ArrayList();
    }

    public Object clone() {
        int size = this.size();
        TupleList l = new TupleList(size);
        ArrayList<Tuple> list = l.listBody;
        for (int i = 0; i < size; ++i) {
            list.add((Tuple)this.listBody.get(i).clone());
        }
        return l;
    }

    public Object[] toArray() {
        return this.listBody.toArray();
    }

    public boolean isEmpty() {
        return this.listBody.isEmpty();
    }

    public Iterator<Tuple> iterator() {
        return this.listBody.iterator();
    }

    void reinit(TupleList list) {
        this.listBody = new ArrayList(list.size());
        this.listBody.addAll(list.getList());
    }

    ArrayList<Tuple> getList() {
        return this.listBody;
    }

    void setList(ArrayList<Tuple> l) {
        this.listBody = l;
    }

    TupleList getTupleList(int col) throws IndexOutOfBoundsException {
        int size = this.size();
        TupleList t_l = new TupleList(size);
        for (int i = 0; i < size; ++i) {
            int elem = this.listBody.get(i).get(col);
            Tuple4Node t = new Tuple4Node(elem);
            t_l.add(t);
        }
        return t_l;
    }

    TupleList getTupleList(int[] cols) throws IndexOutOfBoundsException {
        TupleList t_l;
        if (cols.length == 1) {
            t_l = this.getTupleList(cols[0]);
        } else {
            int size = this.size();
            t_l = new TupleList(size);
            for (int i = 0; i < size; ++i) {
                int[] elems = this.listBody.get(i).get(cols);
                TupleImpl t = new TupleImpl(elems, false);
                t_l.add(t);
            }
        }
        return t_l;
    }

    public TupleList select(TupleSelector selector) {
        TupleList t_l = new TupleList();
        if (selector == null) {
            return t_l;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.listBody.get(i);
            if (!selector.select(t)) continue;
            t_l.add(t);
        }
        return t_l;
    }

    void sort() {
        int count = this.listBody.size();
        TupleList t_l = new TupleList(count);
        if (count > 0) {
            RadixSorter.sort(this, t_l);
            this.listBody = t_l.listBody;
        }
    }

    void sort(int col) {
        int count = this.listBody.size();
        TupleList t_l = new TupleList(count);
        if (count > 0) {
            RadixSorter.sort(this, col, t_l);
            this.listBody = t_l.listBody;
        }
    }

    TupleList removeDuplicates() {
        int count = this.listBody.size();
        TupleList dupList = new TupleList();
        if (count > 0) {
            ArrayList<Tuple> al = new ArrayList<Tuple>(this.size());
            Tuple prev = this.listBody.get(0);
            al.add(prev);
            for (int i = 1; i < count; ++i) {
                Tuple next = this.listBody.get(i);
                if (prev.compareTo(next) != 0) {
                    al.add(next);
                } else {
                    dupList.add(next);
                }
                prev = next;
            }
            this.listBody = al;
        }
        return dupList;
    }

    TupleList sort_removeDuplicates() {
        this.sort();
        return this.removeDuplicates();
    }
}

