/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleImpl;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public class TupleSet
implements Cloneable {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_DUPLICATE = 4;
    protected int flags = 0;
    protected String name = "?";
    protected int sortLevel = -1;
    protected TupleList data;

    public TupleSet() {
        this.data = new TupleList(5);
    }

    public TupleSet(int initialCapacity) {
        this.data = new TupleList(initialCapacity);
    }

    public TupleSet(String name) {
        if (name != null) {
            this.name = name;
        }
        this.data = new TupleList(5);
    }

    public boolean hasName() {
        return this.name != null && this.name != "?";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public void setFlag(int flag) {
        this.flags = flag == 0 ? flag : (this.flags |= flag);
    }

    public void unsetFlag(int flag) {
        this.flags &= ~flag;
    }

    public boolean hasDuplicates() {
        if (this.flags == 0) {
            this.setFlag(4);
        }
        return (this.flags & 4) != 0;
    }

    public void setHasDuplicates(boolean b) {
        if (b) {
            this.setFlag(4);
        } else {
            this.unsetFlag(4);
        }
    }

    public int size() {
        return this.data.size();
    }

    public int columns() {
        if (this.size() > 0) {
            Tuple t = this.data.getList().get(0);
            return t.size();
        }
        if (this instanceof NodeSet) {
            return 1;
        }
        if (this instanceof EdgeSet) {
            return 2;
        }
        return 0;
    }

    public void add(Tuple t) {
        if (t != null) {
            this.data.add(t);
            this.flags = 0;
            this.sortLevel = -1;
        }
    }

    public Tuple get(int index) {
        return this.data.get(index);
    }

    public Tuple[] getAllTuples() {
        int count = this.size();
        Tuple[] result = new Tuple[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.data.get(i);
        }
        return result;
    }

    public TupleList getTupleList() {
        return this.data;
    }

    public TupleSet newSet() {
        TupleSet inst = new TupleSet();
        return inst;
    }

    public Object clone() {
        TupleSet tupSet = this.newSet();
        tupSet.name = this.name;
        tupSet.flags = this.flags;
        tupSet.data = (TupleList)this.data.clone();
        return tupSet;
    }

    protected void sort() {
        this.data.sort();
        this.sortLevel = this.size() > 1 ? (this.data.get(0).size() == this.data.get(this.size() - 1).size() ? 0 : -1) : 0;
    }

    protected void sortDom() {
        this.trySort(0);
    }

    protected void sortRng() {
        TupleList t_l = new TupleList(this.data.size());
        RadixSorter.sortRng(this.data, t_l);
        this.sortLevel = -1;
        this.data = t_l;
    }

    protected void trySort(int level) {
        if (this.sortLevel != level) {
            this.sortLevel = level;
            TupleList t_l = new TupleList(this.data.size());
            RadixSorter.sort(this.data, level, t_l);
            this.data = t_l;
        }
    }

    public void removeDuplicates() {
        if (this.hasDuplicates()) {
            this.sort();
            this.data.removeDuplicates();
            this.unsetFlag(4);
        }
    }

    public void print(OutputStream out) {
        StringBuffer buffer = new StringBuffer();
        PrintWriter writer = new PrintWriter(out, true);
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            int k;
            Tuple t = this.data.get(i);
            buffer.delete(0, buffer.length());
            for (k = 0; k < t.size() - 1; ++k) {
                buffer.append(IDManager.get(t.get(k)));
                buffer.append(' ');
            }
            if (k > 0) {
                buffer.append(IDManager.get(t.get(k)));
            }
            if (buffer.length() <= 0) continue;
            writer.println(buffer);
        }
        writer.flush();
    }

    public void printTA(String name1, PrintWriter writer) {
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.data.get(i);
            writer.print(name1);
            for (int k = 0; k < t.size(); ++k) {
                writer.print(' ');
                String field = IDManager.get(t.get(k));
                if (field.charAt(0) == '$' && !field.equals("$ENTITY")) {
                    if (field.equals("$RELATION")) {
                        field = "($RELATION)";
                    } else if ((field = field.substring(1)).charAt(0) == '_') {
                        if ((field = field.substring(1)).charAt(0) == '$') {
                            field = field.substring(1);
                        }
                        field = "(" + field + ")";
                    }
                }
                writer.print(field);
            }
            writer.println();
        }
    }

    public void printRSF(String name1, PrintWriter writer) {
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.data.get(i);
            writer.print(name1);
            for (int k = 0; k < t.size(); ++k) {
                writer.print(' ');
                String field = IDManager.get(t.get(k));
                writer.print(field);
            }
            writer.println();
        }
    }

    public void appendDB(String fileName) throws IOException {
        StringBuffer buffer = new StringBuffer(this.name);
        RandomAccessFile raf = new RandomAccessFile(new File(fileName), "rw");
        raf.seek(raf.length());
        int size = this.data.size();
        int nameLength = this.name.length();
        for (int i = 0; i < size; ++i) {
            Tuple t = this.data.get(i);
            buffer.delete(nameLength, buffer.length());
            for (int k = 0; k < t.size(); ++k) {
                buffer.append(' ');
                buffer.append(IDManager.get(t.get(k)));
            }
            raf.writeBytes(buffer + "\n");
        }
        raf.close();
    }

    public void add(String[] elems) {
        int[] ids = new int[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            ids[i] = IDManager.getID(elems[i]);
        }
        this.data.add(new TupleImpl(ids, false));
        this.sortLevel = -1;
        this.flags = 0;
    }
}

