/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TypeOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class AdditiveExpressionNode
extends ExpressionNode {
    int op;
    ExpressionNode left;
    ExpressionNode right;

    public AdditiveExpressionNode(int op, ExpressionNode left, ExpressionNode right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.left.propagate(env, userObj);
        this.right.propagate(env, userObj);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value valL = this.left.evaluate(env);
        Value valR = this.right.evaluate(env);
        TypeOperation TOP = TypeOperation.analyze(this.op, valL.getType(), valR.getType());
        if (TOP != null) {
            try {
                Operation operation = TOP.getOperation();
                return operation.eval(this.op, valL, valR);
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
        String err = ErrorMessage.errUnsupportedOperation(this.op, valL.getType(), valR.getType());
        throw new EvaluationException((SyntaxTreeNode)this, err);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.left);
        buffer.append(" ");
        buffer.append(Operator.key(this.op));
        buffer.append(" ");
        buffer.append(this.right);
        return buffer.toString();
    }
}

