/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class ArgumentsNode
extends ExpressionNode {
    ExpressionNode[] args;

    public ArgumentsNode(ExpressionNode[] args) {
        this.args = args;
        if (args == null) {
            this.args = new ExpressionNode[0];
        }
    }

    public ExpressionNode[] getArguments() {
        return this.args;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].propagate(env, userObj);
        }
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value[] argValues = new Value[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            argValues[i] = this.args[i].evaluate(env);
        }
        if (this.args.length == 1) {
            return argValues[0];
        }
        return new Value(argValues);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            buffer.append(this.args[i]);
            buffer.append(", ");
        }
        if (this.args.length == 0) {
            buffer.append(')');
        } else {
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.setCharAt(buffer.length() - 1, ')');
        }
        return buffer.toString();
    }
}

