/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TypeOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;

public class AssignmentExtensionNode
extends StatementNode {
    int op;
    VariableNode left;
    ExpressionNode expNode;

    public AssignmentExtensionNode(int op, VariableNode left, ExpressionNode expNode) {
        this.op = op;
        this.left = left;
        this.expNode = expNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Variable var;
        String evalName;
        Scope scp = env.peepScope();
        try {
            evalName = this.left.evalName(env);
        }
        catch (EvaluationException e) {
            evalName = this.left.toString();
        }
        try {
            var = scp.lookup(evalName);
        }
        catch (LookupException e) {
            throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
        }
        Value valL = var.getValue();
        Value valR = this.expNode.evaluate(env);
        if (valL.isPrimitive() && valR.isPrimitive()) {
            int opProxy = this.op;
            TypeOperation typeOp = null;
            switch (this.op) {
                case 23: {
                    opProxy = 12;
                    break;
                }
                case 24: {
                    opProxy = 13;
                    break;
                }
                case 25: {
                    opProxy = 15;
                    break;
                }
                case 26: {
                    opProxy = 18;
                    break;
                }
            }
            typeOp = TypeOperation.analyze(opProxy, valL.getType(), valR.getType());
            if (typeOp == null) {
                String err = ErrorMessage.errUnsupportedOperation(this.op, valL.getType(), valR.getType());
                throw new EvaluationException((SyntaxTreeNode)this, err);
            }
            try {
                Operation operation = typeOp.getOperation();
                var.setValue(operation.eval(opProxy, valL, valR));
                if (!(var.getValue().objectValue() instanceof TupleSet)) return Value.EVAL;
                ((TupleSet)var.getValue().objectValue()).setName(var.getName());
                return Value.EVAL;
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
        Object objL = valL.objectValue();
        Object objR = valR.objectValue();
        if (objL instanceof TupleSet && objR instanceof TupleSet && this.op == 23) {
            Value val = new Value(AlgebraOperation.append((TupleSet)objL, (TupleSet)objR));
            var.setValue(val);
            if (!(var.getValue().objectValue() instanceof TupleSet)) return Value.EVAL;
            ((TupleSet)var.getValue().objectValue()).setName(var.getName());
            return Value.EVAL;
        }
        String err = ErrorMessage.errUnsupportedOperation(this.op, valL.getType(), valR.getType());
        throw new EvaluationException((SyntaxTreeNode)this, err);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.left);
        buffer.append(' ');
        buffer.append(Operator.key(this.op));
        buffer.append(' ');
        buffer.append(this.expNode);
        buffer.append(';');
        return buffer.toString();
    }
}

