/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;

public class AssignmentNode
extends StatementNode {
    VariableNode[] lefts;
    ExpressionNode expNode;

    public AssignmentNode(VariableNode left, ExpressionNode expNode) {
        this.lefts = new VariableNode[1];
        this.lefts[0] = left;
        this.expNode = expNode;
    }

    public AssignmentNode(VariableNode[] lefts, ExpressionNode expNode) {
        this.lefts = lefts;
        this.expNode = expNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value evaluate(Env env) throws EvaluationException {
        int i;
        Value val;
        Variable[] vars = new Variable[this.lefts.length];
        for (int i2 = 0; i2 < this.lefts.length; ++i2) {
            Variable var;
            String evalName;
            VariableNode left = this.lefts[i2];
            try {
                evalName = left.evalName(env);
            }
            catch (EvaluationException e) {
                evalName = left.toString();
            }
            if (Env.isReservedWord(evalName)) {
                throw EvaluationException.createReservedWordException(this.lefts[i2]);
            }
            try {
                var = env.lookup(evalName);
            }
            catch (LookupException e) {
                Scope scp = env.peepScope();
                var = new Variable(scp, evalName);
                scp.addVariable(var);
            }
            vars[i2] = var;
        }
        try {
            val = this.expNode.evaluate(env);
        }
        catch (EvaluationException e) {
            for (int j = 0; j < vars.length; ++j) {
                if (vars[j].getValue() != null) continue;
                vars[j].getScope().removeVariable(vars[j]);
            }
            throw e;
        }
        Object o = val.objectValue();
        if (!(o instanceof Value[])) {
            if (this.lefts.length == 1) {
                if (o instanceof TupleSet) {
                    TupleSet aSet = (TupleSet)o;
                    if (aSet.hasName()) {
                        val = new Value(aSet.clone());
                        aSet = (TupleSet)val.objectValue();
                    }
                    aSet.setName(vars[0].getName());
                    aSet.removeDuplicates();
                }
            } else {
                for (int j = 1; j < vars.length; ++j) {
                    if (vars[j].getValue() != null) continue;
                    vars[j].getScope().removeVariable(vars[j]);
                }
                if (vars.length > 1) {
                    throw new EvaluationException((SyntaxTreeNode)this.lefts[1], vars[1].getName() + " not assigned a value");
                }
            }
            vars[0].setValue(val);
            return Value.EVAL;
        }
        Value[] vals = (Value[])o;
        if (this.lefts.length == 1) {
            if (vals.length < 1) throw new EvaluationException((SyntaxTreeNode)this.lefts[0], vars[0].getName() + " not assigned a value");
            val = vals[0];
            o = val.objectValue();
            if (o instanceof TupleSet) {
                TupleSet aSet = (TupleSet)o;
                if (aSet.hasName()) {
                    val = new Value(aSet.clone());
                    aSet = (TupleSet)val.objectValue();
                }
                aSet.setName(vars[0].getName());
                aSet.removeDuplicates();
            }
            vars[0].setValue(val);
            return Value.EVAL;
        }
        try {
            for (i = 0; i < this.lefts.length; ++i) {
                val = vals[i];
                Object oi = val.objectValue();
                if (oi instanceof TupleSet) {
                    TupleSet aSet = (TupleSet)oi;
                    if (aSet.hasName()) {
                        val = new Value(aSet.clone());
                        aSet = (TupleSet)val.objectValue();
                    }
                    aSet.setName(vars[i].getName());
                    aSet.removeDuplicates();
                }
                vars[i].setValue(val);
            }
            return Value.EVAL;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            for (int j = 0; j < vars.length; ++j) {
                if (vars[j].getValue() != null) continue;
                vars[j].getScope().removeVariable(vars[j]);
            }
            throw new EvaluationException((SyntaxTreeNode)this.lefts[i], vars[i].getName() + " not assigned a value");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.lefts.length == 1) {
            buffer.append(this.lefts[0]);
        } else {
            buffer.append('(');
            for (int i = 0; i < this.lefts.length; ++i) {
                buffer.append(this.lefts[i]);
                buffer.append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length());
            buffer.append(')');
        }
        buffer.append(" = ");
        buffer.append(this.expNode);
        buffer.append(';');
        return buffer.toString();
    }
}

