/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.ArgumentsNode;
import ca.uwaterloo.cs.jgrok.interp.CommandNode;
import ca.uwaterloo.cs.jgrok.interp.EvalName;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;

public class CommandDeleteNode
extends CommandNode {
    ExpressionNode expNode;

    public CommandDeleteNode(ExpressionNode expNode) {
        super("delete");
        this.expNode = expNode;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Scope scp = env.peepScope();
        if (this.expNode instanceof ArgumentsNode) {
            ArgumentsNode argsNode = (ArgumentsNode)this.expNode;
            ExpressionNode[] args = argsNode.getArguments();
            for (int i = 0; i < args.length; ++i) {
                Variable var;
                String name;
                ExpressionNode arg = args[i];
                if (arg instanceof EvalName) {
                    name = ((EvalName)((Object)arg)).evalName(env);
                } else {
                    Value val = arg.evaluate(env);
                    if (val.getType() == String.class) {
                        name = val.toString();
                    } else {
                        throw new EvaluationException((SyntaxTreeNode)arg, "illegal expression: " + arg);
                    }
                }
                try {
                    var = scp.lookup(name);
                }
                catch (LookupException e) {
                    continue;
                }
                scp.removeVariable(var);
            }
        } else {
            Variable var;
            String name;
            if (this.expNode instanceof EvalName) {
                name = ((EvalName)((Object)this.expNode)).evalName(env);
            } else {
                Value val = this.expNode.evaluate(env);
                if (val.getType() == String.class) {
                    name = val.toString();
                } else {
                    throw new EvaluationException((SyntaxTreeNode)this.expNode, "illegal expression: " + this.expNode);
                }
            }
            try {
                var = scp.lookup(name);
            }
            catch (LookupException e) {
                return Value.EVAL;
            }
            scp.removeVariable(var);
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("delete");
        if (!(this.expNode instanceof ArgumentsNode)) {
            buffer.append(' ');
        }
        buffer.append(this.expNode);
        buffer.append(';');
        return buffer.toString();
    }
}

