/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.CommandNode;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;
import ca.uwaterloo.cs.jgrok.lib.Function;

public class CommandHelpNode
extends CommandNode {
    VariableNode varNode;

    public CommandHelpNode(VariableNode varNode) {
        super("help");
        this.varNode = varNode;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        block6: {
            if (this.varNode == null) {
                env.out.println("help [$|@] identifier");
                return Value.EVAL;
            }
            String name = this.varNode.toString();
            LookupException e = null;
            try {
                Variable var = env.lookup(name);
                env.out.println("Variable: " + var.getType().getName() + " " + var.getName());
            }
            catch (LookupException e1) {
                e = e1;
            }
            try {
                Function function = env.lookupFunction(name);
                String usage = function.usage();
                if (usage != null) {
                    env.out.println(usage);
                }
            }
            catch (LookupException e2) {
                if (e == null) break block6;
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("help");
        if (this.varNode != null) {
            buffer.append(' ');
            buffer.append(this.varNode);
        }
        buffer.append(';');
        return buffer.toString();
    }
}

