/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class ConditionalOrExpressionNode
extends ExpressionNode {
    ExpressionNode left;
    ExpressionNode right;

    public ConditionalOrExpressionNode(ExpressionNode left, ExpressionNode right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.left.propagate(env, userObj);
        this.right.propagate(env, userObj);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value valL = this.left.evaluate(env);
        Value valR = this.right.evaluate(env);
        Class<?> type = valL.getType();
        if (type != Boolean.TYPE) {
            throw new EvaluationException((SyntaxTreeNode)this.left, "boolean expression expected");
        }
        type = valR.getType();
        if (type != Boolean.TYPE) {
            throw new EvaluationException((SyntaxTreeNode)this.right, "boolean expression expected");
        }
        return new Value(valL.booleanValue() || valR.booleanValue());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.left);
        buffer.append(" || ");
        buffer.append(this.right);
        return buffer.toString();
    }
}

