/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvalName;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;

public class DollarSignNode
extends VariableNode
implements EvalName {
    public DollarSignNode(String name) {
        super(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        try {
            Variable var = env.lookup(this.evalName(env));
            if (var.getValue() == null) {
                throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errUnresolvable(this.evalName(env)));
            }
            return var.getValue();
        }
        catch (LookupException e) {
            throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
        }
    }

    @Override
    public String evalName(Env env) throws EvaluationException {
        try {
            Variable var = env.lookup(this.toString());
            if (var.getValue() == null) {
                throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errUnresolvable(this.toString()));
            }
            return var.getName();
        }
        catch (LookupException e1) {
            try {
                Variable var = env.lookup(this.name);
                Value val = var.getValue();
                if (val == null) {
                    throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errUnresolvable(this.name));
                }
                if (val.getType() != String.class) {
                    throw new EvaluationException((SyntaxTreeNode)this, "String expected after $");
                }
                return val.toString();
            }
            catch (LookupException e2) {
                throw new EvaluationException((SyntaxTreeNode)this, e1.getMessage());
            }
        }
    }

    @Override
    public String toString() {
        return "$" + this.name;
    }
}

