/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.LocalScopedNode;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;
import java.util.Iterator;

public class ForStatementNode
extends StatementNode {
    VariableNode varNode;
    ExpressionNode expNode;
    StatementNode bodyNode;

    public ForStatementNode(VariableNode varNode, ExpressionNode expNode, StatementNode bodyNode) {
        this.varNode = varNode;
        this.expNode = expNode;
        this.bodyNode = bodyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value evaluate(Env env) throws EvaluationException {
        block14: {
            Variable var;
            Value expVal = this.expNode.evaluate(env);
            Class<?> expType = expVal.getType();
            env.pushScope(new LocalScopedNode(env.peepScope()));
            try {
                var = env.peepScope().lookup(this.varNode.getName());
            }
            catch (LookupException e) {
                Scope scp = env.peepScope();
                var = new Variable(scp, this.varNode.getName());
                scp.addVariable(var);
            }
            try {
                if (expType == NodeSet.class) {
                    NodeSet set = (NodeSet)expVal.objectValue();
                    Node[] nodes = set.getAllNodes();
                    for (int i = 0; i < nodes.length; ++i) {
                        var.setValue(new Value(nodes[i].get()));
                        Value stmtVal = this.bodyNode.evaluate(env);
                        if (stmtVal == Value.EVAL) continue;
                        Value value = stmtVal;
                        return value;
                    }
                    break block14;
                }
                if (expVal.objectValue() instanceof Object[]) {
                    Object[] objs = (Object[])expVal.objectValue();
                    for (int i = 0; i < objs.length; ++i) {
                        var.setValue(new Value(objs[i]));
                        Value stmtVal = this.bodyNode.evaluate(env);
                        if (stmtVal == Value.EVAL) continue;
                        Value value = stmtVal;
                        return value;
                    }
                    break block14;
                }
                if (expVal.objectValue() instanceof Iterable) {
                    Iterator iter = ((Iterable)expVal.objectValue()).iterator();
                    while (iter.hasNext()) {
                        var.setValue(new Value(iter.next()));
                        Value stmtVal = this.bodyNode.evaluate(env);
                        if (stmtVal == Value.EVAL) continue;
                        Value value = stmtVal;
                        return value;
                    }
                    break block14;
                }
                throw new EvaluationException((SyntaxTreeNode)this.expNode, "illegal expression (set, array, iterable required)");
            }
            finally {
                env.popScope();
            }
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("for");
        buffer.append(' ');
        buffer.append(this.varNode);
        buffer.append(' ');
        buffer.append("in");
        buffer.append(' ');
        buffer.append(this.expNode);
        buffer.append(' ');
        buffer.append(this.bodyNode);
        return buffer.toString();
    }
}

