/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Clazz;
import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.ArgumentsNode;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.FunctionNameNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.FunctionLib;
import java.lang.reflect.Method;

public class FunctionExpressionNode
extends ExpressionNode {
    FunctionNameNode nameNode;
    ArgumentsNode argsNode;
    private Value[] argVals = null;
    private Object[] argObjs = null;
    private Class<?>[] argTypes = null;
    private EvaluationException argsEvalException = null;

    public FunctionExpressionNode(FunctionNameNode nameNode, ArgumentsNode argsNode) {
        this.nameNode = nameNode;
        this.argsNode = argsNode;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.nameNode.propagate(env, userObj);
        this.argsNode.propagate(env, userObj);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Function function = null;
        String funcName = null;
        this.evalArguments(env);
        try {
            funcName = this.nameNode.evalName(env);
            function = env.lookupFunction(funcName);
            Value value = function.invoke(env, this.argVals);
            return value;
        }
        catch (Exception e) {
            throw new EvaluationException((SyntaxTreeNode)this, funcName + "(): " + e.getMessage());
        }
        finally {
            this.cleanEvaluatedArguments();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.nameNode);
        buffer.append(this.argsNode);
        return buffer.toString();
    }

    private void cleanEvaluatedArguments() {
        this.argVals = null;
        this.argObjs = null;
        this.argTypes = null;
        this.argsEvalException = null;
    }

    private void evalArguments(Env env) throws EvaluationException {
        int i;
        Value argsValue;
        if (this.argsEvalException != null) {
            throw this.argsEvalException;
        }
        if (this.argVals != null) {
            return;
        }
        try {
            argsValue = this.argsNode.evaluate(env);
        }
        catch (EvaluationException e) {
            this.argsEvalException = e;
            throw e;
        }
        Object o = argsValue.objectValue();
        if (o instanceof Value[]) {
            this.argVals = (Value[])o;
        } else {
            this.argVals = new Value[1];
            this.argVals[0] = argsValue;
        }
        this.argObjs = new Object[this.argVals.length];
        for (i = 0; i < this.argVals.length; ++i) {
            this.argObjs[i] = this.argVals[i].objectValue();
        }
        this.argTypes = new Class[this.argVals.length];
        for (i = 0; i < this.argVals.length; ++i) {
            this.argTypes[i] = this.argVals[i].getType();
        }
    }

    Value evalConstructor(Env env, Class<?> clazz) throws NoSuchMethodException, EvaluationException {
        this.evalArguments(env);
        try {
            Object result = null;
            result = this.argObjs.length == 0 ? Clazz.newInstance(clazz) : Clazz.newInstance(clazz, this.argVals);
            this.cleanEvaluatedArguments();
            return new Value(result);
        }
        catch (InstantiationException e) {
            throw new EvaluationException((SyntaxTreeNode)this, e);
        }
    }

    Value evalClassMethod(Env env, Class<?> clazz) throws NoSuchMethodException, EvaluationException {
        this.evalArguments(env);
        String methodName = this.nameNode.evalName(env);
        Method m = Clazz.getStaticMethod(clazz, methodName, this.argTypes);
        if (m != null) {
            try {
                Object result = m.invoke(null, this.argObjs);
                this.cleanEvaluatedArguments();
                if (result == null) {
                    return Value.VOID;
                }
                return new Value(result);
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e);
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    Value evalInstanceMethod(Env env, Object obj) throws NoSuchMethodException, EvaluationException {
        this.evalArguments(env);
        Class<?> clazz = obj.getClass();
        String methodName = this.nameNode.evalName(env);
        Method m = Clazz.getMethod(clazz, methodName, this.argTypes);
        if (m != null) {
            try {
                Object result = m.invoke(obj, this.argObjs);
                this.cleanEvaluatedArguments();
                if (result == null) {
                    return Value.VOID;
                }
                return new Value(result);
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e);
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    Value evalFunction(Env env, FunctionLib lib) throws NoSuchMethodException, EvaluationException {
        this.evalArguments(env);
        String funcName = this.nameNode.evalName(env);
        Function function = lib.find(funcName);
        if (function == null) {
            throw new NoSuchMethodException(funcName + " not in FunctionLib " + lib.getName());
        }
        try {
            Value result = function.invoke(env, this.argVals);
            this.cleanEvaluatedArguments();
            return result;
        }
        catch (Exception e) {
            throw new EvaluationException((SyntaxTreeNode)this, funcName + "(): " + e);
        }
    }
}

