/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class IfStatementNode
extends StatementNode {
    ExpressionNode expNode;
    StatementNode thenNode;
    StatementNode elseNode;

    public IfStatementNode(ExpressionNode expNode, StatementNode thenNode) {
        this(expNode, thenNode, null);
    }

    public IfStatementNode(ExpressionNode expNode, StatementNode thenNode, StatementNode elseNode) {
        this.expNode = expNode;
        this.thenNode = thenNode;
        this.elseNode = elseNode;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value val = this.expNode.evaluate(env);
        if (val.getType() != Boolean.TYPE) {
            throw new EvaluationException((SyntaxTreeNode)this.expNode, "not evaluated to boolean");
        }
        if (val.booleanValue()) {
            return this.thenNode.evaluate(env);
        }
        if (this.elseNode != null) {
            return this.elseNode.evaluate(env);
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("if ");
        buffer.append(this.expNode);
        buffer.append(' ');
        buffer.append(this.thenNode);
        if (this.elseNode != null) {
            buffer.append("\n");
            buffer.append("else");
            buffer.append(' ');
            buffer.append(this.elseNode);
        }
        return buffer.toString();
    }
}

