/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Clazz;
import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.AttrSignNode;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.FunctionExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.NotQualifiedNameException;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.QualifiedNameExpression;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TypeOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;
import ca.uwaterloo.cs.jgrok.lib.FunctionLib;
import ca.uwaterloo.cs.jgrok.lib.FunctionLibManager;

public class MultiplicativeExpressionNode
extends ExpressionNode {
    int op;
    ExpressionNode left;
    ExpressionNode right;

    public MultiplicativeExpressionNode(int op, ExpressionNode left, ExpressionNode right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.left.propagate(env, userObj);
        this.right.propagate(env, userObj);
    }

    private Value evaluateQualifiedName(Env env) throws NotQualifiedNameException, NoSuchMethodException, NoSuchFieldException, EvaluationException {
        NotQualifiedNameException nameException = new NotQualifiedNameException();
        String leftName = QualifiedNameExpression.evalQualifiedName(env, this.left).replaceAll(" ", "");
        if (this.right instanceof FunctionExpressionNode) {
            FunctionExpressionNode funNode = (FunctionExpressionNode)this.right;
            try {
                String className = leftName + "." + funNode.nameNode.evalName(env);
                Class<?> clazz = Clazz.forName(className);
                return funNode.evalConstructor(env, clazz);
            }
            catch (ClassNotFoundException e2) {
                try {
                    Class<?> clazz = Clazz.forName(leftName);
                    return funNode.evalClassMethod(env, clazz);
                }
                catch (ClassNotFoundException e22) {
                    FunctionLib lib = FunctionLibManager.findLib(leftName);
                    if (lib != null) {
                        return funNode.evalFunction(env, lib);
                    }
                }
            }
        } else {
            if (this.right instanceof AttrSignNode) {
                throw nameException;
            }
            if (this.right instanceof VariableNode) {
                try {
                    Class<?> clazz = Clazz.forName(leftName);
                    return ((VariableNode)this.right).evalClassField(env, clazz);
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
            }
        }
        throw nameException;
    }

    private Value evaluateInstance(Env env, Object obj) throws NotQualifiedNameException, NoSuchMethodException, NoSuchFieldException, EvaluationException {
        NotQualifiedNameException nameException = new NotQualifiedNameException();
        if (this.right instanceof FunctionExpressionNode) {
            return ((FunctionExpressionNode)this.right).evalInstanceMethod(env, obj);
        }
        if (this.right instanceof AttrSignNode) {
            throw nameException;
        }
        if (this.right instanceof VariableNode) {
            return ((VariableNode)this.right).evalInstanceField(env, obj);
        }
        throw nameException;
    }

    private boolean isQualifiedPossible() {
        if (this.op == 20) {
            if (this.left instanceof MultiplicativeExpressionNode) {
                MultiplicativeExpressionNode multiExp = (MultiplicativeExpressionNode)this.left;
                if (multiExp.op != 20) {
                    return false;
                }
                if (multiExp.left instanceof AttrSignNode || multiExp.right instanceof AttrSignNode) {
                    return false;
                }
                if (multiExp.left instanceof VariableNode && multiExp.right instanceof VariableNode) {
                    return true;
                }
            } else {
                if (this.left instanceof AttrSignNode) {
                    return false;
                }
                if (this.left instanceof VariableNode) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isQualifiedMoreLikely() {
        if (this.isQualifiedPossible()) {
            int rightCol;
            int opCol = this.getLocation().getColumn();
            return opCol + 1 == (rightCol = this.right.getLocation().getColumn());
        }
        return false;
    }

    private Value evaluateQualifiedMoreLikely(Env env) throws EvaluationException {
        Value valL = null;
        Value valR = null;
        try {
            return this.evaluateQualifiedName(env);
        }
        catch (EvaluationException e1) {
            throw e1;
        }
        catch (Exception e2) {
            valL = this.left.evaluate(env);
            try {
                return this.evaluateInstance(env, valL.objectValue());
            }
            catch (EvaluationException e1) {
                throw e1;
            }
            catch (Exception e22) {
                valR = this.right.evaluate(env);
                TypeOperation typeOp = TypeOperation.analyze(this.op, valL.getType(), valR.getType());
                if (typeOp != null) {
                    try {
                        Operation operation = typeOp.getOperation();
                        return operation.eval(this.op, valL, valR);
                    }
                    catch (Exception e) {
                        throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
                    }
                }
                String err = ErrorMessage.errUnsupportedOperation(this.op, valL.getType(), valR.getType());
                throw new EvaluationException((SyntaxTreeNode)this, err);
            }
        }
    }

    private Value evaluateQualifiedLessLikely(Env env) throws EvaluationException {
        Value valL = null;
        Value valR = null;
        try {
            valL = this.left.evaluate(env);
            valR = this.right.evaluate(env);
        }
        catch (EvaluationException e) {
            if (this.op == 20) {
                if (valL == null) {
                    try {
                        return this.evaluateQualifiedName(env);
                    }
                    catch (EvaluationException e1) {
                        throw e1;
                    }
                    catch (Exception e2) {
                        throw e;
                    }
                }
                try {
                    return this.evaluateInstance(env, valL.objectValue());
                }
                catch (EvaluationException e1) {
                    throw e1;
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
        TypeOperation typeOp = TypeOperation.analyze(this.op, valL.getType(), valR.getType());
        if (typeOp != null) {
            try {
                Operation operation = typeOp.getOperation();
                return operation.eval(this.op, valL, valR);
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
        String err = ErrorMessage.errUnsupportedOperation(this.op, valL.getType(), valR.getType());
        throw new EvaluationException((SyntaxTreeNode)this, err);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        if (this.isQualifiedMoreLikely()) {
            return this.evaluateQualifiedMoreLikely(env);
        }
        return this.evaluateQualifiedLessLikely(env);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.left);
        if (this.op == 20) {
            int rightCol;
            int opCol = this.getLocation().getColumn();
            if (opCol + 1 == (rightCol = this.right.getLocation().getColumn())) {
                buffer.append(Operator.key(this.op));
            } else {
                buffer.append(' ');
                buffer.append(Operator.key(this.op));
                buffer.append(' ');
            }
        } else {
            buffer.append(' ');
            buffer.append(Operator.key(this.op));
            buffer.append(' ');
        }
        buffer.append(this.right);
        return buffer.toString();
    }
}

