/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TypeOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class PrefixExpressionNode
extends ExpressionNode {
    int op;
    ExpressionNode expNode;

    public PrefixExpressionNode(int op, ExpressionNode expNode) {
        this.op = op;
        this.expNode = expNode;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.expNode.propagate(env, userObj);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value val = this.expNode.evaluate(env);
        TypeOperation TOP = TypeOperation.analyze(this.op, val.getType());
        if (TOP != null) {
            try {
                Operation operation = TOP.getOperation();
                return operation.eval(this.op, val);
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
        String err = ErrorMessage.errUnsupportedOperation(this.op, val.getType());
        throw new EvaluationException((SyntaxTreeNode)this, err);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Operator.key(this.op));
        buffer.append(" ");
        buffer.append(this.expNode);
        return buffer.toString();
    }
}

