/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.interp.BlockStatementNode;
import ca.uwaterloo.cs.jgrok.interp.ForStatementNode;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNodeVisitor;
import java.io.PrintStream;
import java.util.ArrayList;

public class PrintVisitor
implements SyntaxTreeNodeVisitor {
    private PrintStream out;
    private ArrayList<StringBuffer> lines;

    public PrintVisitor(PrintStream out) {
        this.out = out;
        this.lines = new ArrayList();
    }

    @Override
    public void visit(SyntaxTreeNode nd) {
        if (nd instanceof ForStatementNode) {
            this.process((ForStatementNode)nd);
        } else if (nd instanceof StatementNode) {
            this.process((StatementNode)nd);
        } else {
            StringBuffer buf = this.getBuffer(nd.getLocation().getLine());
            buf.append(nd.toString());
        }
        for (int i = nd.getLocation().getLine(); i < this.lines.size(); ++i) {
            this.out.println(this.getLine(i));
        }
    }

    public String getLine(int lineNum) {
        this.getBuffer(lineNum);
        return this.lines.get(lineNum).toString();
    }

    public void setLine(int lineNum, String line) {
        this.getBuffer(lineNum);
        this.lines.set(lineNum, new StringBuffer(line));
    }

    private StringBuffer getBuffer(int lineNum) {
        for (int i = this.lines.size(); i <= lineNum; ++i) {
            this.lines.add(new StringBuffer());
        }
        return this.lines.get(lineNum);
    }

    private void fillIndent(StringBuffer buffer, SyntaxTreeNode nd) {
        for (int i = buffer.length(); i < nd.getLocation().getColumn() - 1; ++i) {
            buffer.append(' ');
        }
    }

    private void process(StatementNode nd) {
        StringBuffer buf = this.getBuffer(nd.getLocation().getLine());
        buf.append(nd);
    }

    private void process(ForStatementNode nd) {
        StringBuffer buf = this.getBuffer(nd.getLocation().getLine());
        this.fillIndent(buf, nd);
        buf.append("for");
        buf.append(' ');
        buf.append(nd.varNode);
        buf.append(' ');
        buf.append("in");
        buf.append(' ');
        buf.append(nd.expNode);
        if (nd.bodyNode instanceof BlockStatementNode) {
            this.process(nd, (BlockStatementNode)nd.bodyNode);
        } else {
            this.process(nd.bodyNode);
        }
    }

    private void process(StatementNode parent, BlockStatementNode nd) {
        StringBuffer buf = this.getBuffer(nd.getLocation().getLine());
        this.fillIndent(buf, nd);
        buf.append('{');
        for (int i = 0; i < nd.stmtNodes.size(); ++i) {
            this.process(nd.stmtNodes.get(i));
        }
        buf = this.getBuffer(this.lines.size());
        buf.append('}');
    }
}

