/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Header;
import ca.uwaterloo.cs.jgrok.fb.Relation;
import ca.uwaterloo.cs.jgrok.fb.UnknownColumnException;
import ca.uwaterloo.cs.jgrok.interp.BlockStatementNode;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.PrologExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import java.util.ArrayList;

public class PrologClauseNode
extends StatementNode {
    PrologExpressionNode expNode;
    StatementNode bodyNode;

    public PrologClauseNode(PrologExpressionNode expNode, StatementNode bodyNode) {
        this.expNode = expNode;
        this.bodyNode = bodyNode;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Header header = this.expNode.getHeader();
        if (this.bodyNode instanceof BlockStatementNode) {
            Variable var;
            ArrayList<StatementNode> nodes = ((BlockStatementNode)this.bodyNode).stmtNodes;
            ArrayList<Relation> myRels = new ArrayList<Relation>();
            for (int i = 0; i < nodes.size(); ++i) {
                StatementNode s = nodes.get(i);
                if (!(s instanceof PrologExpressionNode)) continue;
                Value val = s.evaluate(env);
                myRels.add((Relation)val.objectValue());
            }
            this.compose(myRels);
            Relation rel = myRels.get(0);
            try {
                rel = Relation.project(rel, header);
            }
            catch (UnknownColumnException e) {
                throw new EvaluationException((SyntaxTreeNode)this.expNode, e.getMessage());
            }
            Scope scp = env.peepScope();
            String name = this.expNode.varNode.toString();
            try {
                var = scp.lookup(name);
            }
            catch (LookupException e) {
                var = new Variable(scp, name);
                scp.addVariable(var);
            }
            var.setValue(new Value(rel.getBody()));
            return Value.EVAL;
        }
        return this.bodyNode.evaluate(env);
    }

    private void compose(ArrayList<Relation> myRels) {
        boolean outLoop = true;
        block0: while (outLoop) {
            outLoop = false;
            for (int i = 0; i < myRels.size(); ++i) {
                Relation source = myRels.get(i);
                Header srcHeader = source.getHeader();
                for (int j = i + 1; j < myRels.size(); ++j) {
                    Relation target = myRels.get(j);
                    Header trgHeader = target.getHeader();
                    Header h = srcHeader.intersect(trgHeader);
                    if (h.size() <= 0) continue;
                    Relation rel = Relation.compose(source, target, h);
                    myRels.remove(j);
                    myRels.remove(i);
                    myRels.add(rel);
                    outLoop = true;
                    break;
                }
                if (outLoop) continue block0;
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.expNode);
        buffer.append(" = ");
        buffer.append(this.bodyNode);
        return buffer.toString();
    }
}

