/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Column;
import ca.uwaterloo.cs.jgrok.fb.Header;
import ca.uwaterloo.cs.jgrok.fb.Relation;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;
import java.util.ArrayList;

public class PrologExpressionNode
extends StatementNode {
    VariableNode varNode;
    ArrayList<VariableNode> argVarNodes;

    public PrologExpressionNode(VariableNode varNode, ArrayList<VariableNode> argVarNodes) {
        this.varNode = varNode;
        this.argVarNodes = argVarNodes;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value val = this.varNode.evaluate(env);
        if (val.objectValue() instanceof TupleSet) {
            Relation rel = new Relation(this.getHeader(), (TupleSet)val.objectValue(), true);
            return new Value(rel);
        }
        throw new EvaluationException((SyntaxTreeNode)this.varNode, "unknown prolog error //???");
    }

    Header getHeader() {
        int count = this.argVarNodes.size();
        Column[] cols = new Column[count];
        for (int i = 0; i < count; ++i) {
            cols[i] = new Column(this.argVarNodes.get(i).toString());
        }
        return new Header(cols);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.varNode);
        buffer.append('[');
        for (int i = 0; i < this.argVarNodes.size(); ++i) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(this.argVarNodes.get(i));
        }
        buffer.append(']');
        return buffer.toString();
    }
}

