/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.AttrSignNode;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.MultiplicativeExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.NotQualifiedNameException;
import ca.uwaterloo.cs.jgrok.interp.VariableNode;

public class QualifiedNameExpression {
    public static String evalQualifiedName(Env env, ExpressionNode nd) throws NotQualifiedNameException {
        StringBuffer buffer = new StringBuffer(100);
        QualifiedNameExpression.evalQualifiedName(env, nd, buffer);
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void evalQualifiedName(Env env, ExpressionNode nd, StringBuffer buffer) throws NotQualifiedNameException {
        NotQualifiedNameException nameException = new NotQualifiedNameException();
        if (nd instanceof AttrSignNode) {
            throw nameException;
        }
        if (nd instanceof VariableNode) {
            try {
                buffer.append(((VariableNode)nd).evalName(env));
                return;
            }
            catch (EvaluationException e) {
                throw nameException;
            }
        } else {
            int rightCol;
            if (!(nd instanceof MultiplicativeExpressionNode)) throw nameException;
            MultiplicativeExpressionNode multiExp = (MultiplicativeExpressionNode)nd;
            int op = multiExp.op;
            ExpressionNode left = multiExp.left;
            ExpressionNode right = multiExp.right;
            if (op != 20) throw nameException;
            QualifiedNameExpression.evalQualifiedName(env, left, buffer);
            if (right instanceof AttrSignNode) {
                throw nameException;
            }
            if (!(right instanceof VariableNode)) throw nameException;
            int opCol = multiExp.getLocation().getColumn();
            if (opCol + 1 == (rightCol = right.getLocation().getColumn())) {
                buffer.append('.');
            } else {
                buffer.append(' ');
                buffer.append('.');
                buffer.append(' ');
            }
            QualifiedNameExpression.evalQualifiedName(env, right, buffer);
        }
    }
}

