/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.io.FileOutputAppendStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class RedirectStatementNode
extends StatementNode {
    StatementNode stmtNode;
    ExpressionNode expNode;
    boolean isAppend;

    public RedirectStatementNode(StatementNode stmtNode, ExpressionNode expNode, boolean isAppend) {
        this.stmtNode = stmtNode;
        this.expNode = expNode;
        this.isAppend = isAppend;
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value val = this.expNode.evaluate(env);
        if (val.getType() != String.class) {
            throw new EvaluationException((SyntaxTreeNode)this.expNode, "string expected after >>");
        }
        String fileName = val.toString();
        PrintStream oldOut = env.out;
        try {
            fileName = val.toString();
            env.out = this.isAppend ? new PrintStream(new FileOutputAppendStream(fileName), true) : new PrintStream(new FileOutputStream(fileName), true);
            this.stmtNode.evaluate(env);
            env.out.close();
        }
        catch (FileNotFoundException e) {
            throw new EvaluationException((SyntaxTreeNode)this.expNode, fileName + " not found");
        }
        catch (IOException e) {
            throw new EvaluationException((SyntaxTreeNode)this.expNode, e.getMessage());
        }
        finally {
            env.out = oldOut;
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stmtNode);
        buffer.append(' ');
        buffer.append(">>");
        if (this.isAppend) {
            buffer.append('>');
        }
        buffer.append(' ');
        buffer.append(this.expNode);
        buffer.append(';');
        return buffer.toString();
    }
}

