/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ScopedNode
extends SyntaxTreeNode
implements Scope {
    protected Scope parent;
    protected Hashtable<String, Variable> varTbl;

    public ScopedNode(Scope parent) {
        this.parent = parent;
        this.varTbl = new Hashtable();
    }

    @Override
    public void clear() {
        this.varTbl.clear();
    }

    @Override
    public Scope getParent() {
        return this.parent;
    }

    @Override
    public Enumeration<Variable> allVariables() {
        return this.varTbl.elements();
    }

    @Override
    public void addVariable(Variable v) {
        if (v != null) {
            this.varTbl.put(v.getName(), v);
        }
    }

    @Override
    public void removeVariable(Variable v) {
        if (v != null) {
            this.varTbl.remove(v.getName());
        }
    }

    @Override
    public boolean hasVariable(String name) {
        return this.varTbl.containsKey(name);
    }

    @Override
    public abstract Variable lookup(String var1) throws LookupException;
}

