/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.env.Indent;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Option;
import ca.uwaterloo.cs.jgrok.interp.ScopedNode;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.util.Timing;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScriptUnitNode
extends ScopedNode {
    private int currStmtNum = 0;
    private File scriptFile = null;
    private String aliasName = null;
    private Option unitOption = new Option();
    private Hashtable<String, Object> sourceUnits = new Hashtable(5);
    private ArrayList<StatementNode> stmtNodeList = new ArrayList(50);
    private StringBuffer echoIndent = new StringBuffer();

    public ScriptUnitNode() {
        super(null);
    }

    public File getFile() {
        return this.scriptFile;
    }

    public void setFile(File file) {
        if (file != null) {
            try {
                this.scriptFile = file.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.scriptFile = null;
            }
        } else {
            this.scriptFile = null;
        }
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String alias) {
        this.aliasName = alias;
    }

    public String getFileName() {
        if (this.scriptFile != null) {
            return this.scriptFile.getName();
        }
        return null;
    }

    public String getFullName() {
        return this.getFilePath();
    }

    public String getFilePath() {
        if (this.scriptFile != null) {
            return this.scriptFile.getPath();
        }
        return null;
    }

    public String getFileParent() {
        if (this.scriptFile != null) {
            return this.scriptFile.getParent();
        }
        return System.getProperty("user.dir");
    }

    public Option getOption() {
        return this.unitOption;
    }

    public void setOption(Option opt) {
        if (opt != null) {
            this.unitOption = opt;
        }
    }

    public boolean isEchoOn() {
        return this.unitOption.isEchoOn();
    }

    public boolean isTimeOn() {
        return this.unitOption.isTimeOn();
    }

    public boolean isPauseOn() {
        return this.unitOption.isPauseOn();
    }

    public void addStatement(StatementNode stmtNode) {
        if (stmtNode != null) {
            this.stmtNodeList.add(stmtNode);
        }
    }

    public ScriptUnitNode[] getSourceUnits() {
        ArrayList<ScriptUnitNode> aList = new ArrayList<ScriptUnitNode>(5);
        Enumeration<Object> enm = this.sourceUnits.elements();
        while (enm.hasMoreElements()) {
            Object o = enm.nextElement();
            if (o instanceof ScriptUnitNode) {
                aList.add((ScriptUnitNode)o);
                continue;
            }
            aList.addAll(((UnitContainer)o).list);
        }
        ScriptUnitNode[] a = new ScriptUnitNode[aList.size()];
        aList.toArray(a);
        return a;
    }

    public ScriptUnitNode[] getSourceUnits(String alias) {
        ScriptUnitNode[] a;
        if (alias == null) {
            return new ScriptUnitNode[0];
        }
        Object o = this.sourceUnits.get(alias);
        if (o == null) {
            a = new ScriptUnitNode[]{};
        } else if (o instanceof ScriptUnitNode) {
            a = new ScriptUnitNode[]{(ScriptUnitNode)o};
        } else {
            UnitContainer uCon = (UnitContainer)o;
            a = new ScriptUnitNode[uCon.list.size()];
            uCon.list.toArray(a);
        }
        return a;
    }

    public void addSourceUnit(ScriptUnitNode unit) {
        if (unit == null) {
            return;
        }
        String alias = unit.getAliasName();
        if (!this.sourceUnits.containsKey(alias)) {
            this.sourceUnits.put(alias, unit);
        } else {
            Object o = this.sourceUnits.get(alias);
            if (o instanceof ScriptUnitNode) {
                ScriptUnitNode u = (ScriptUnitNode)o;
                if (u.getFilePath().equals(unit.getFilePath())) {
                    Enumeration<Variable> enm = u.allVariables();
                    while (enm.hasMoreElements()) {
                        Variable var = enm.nextElement();
                        var.setValue(null);
                    }
                    this.sourceUnits.put(alias, unit);
                } else {
                    UnitContainer uCon = new UnitContainer(u);
                    uCon.add(unit);
                    this.sourceUnits.put(alias, uCon);
                }
            } else {
                int i;
                ArrayList<ScriptUnitNode> list = ((UnitContainer)o).list;
                for (i = 0; i < list.size(); ++i) {
                    ScriptUnitNode u = list.get(i);
                    if (!u.getFilePath().equals(unit.getFilePath())) continue;
                    Enumeration<Variable> enm = u.allVariables();
                    while (enm.hasMoreElements()) {
                        Variable var = enm.nextElement();
                        var.setValue(null);
                    }
                    list.set(i, unit);
                    break;
                }
                if (i == list.size()) {
                    list.add(unit);
                }
            }
        }
    }

    @Override
    public Variable lookup(String name) throws LookupException {
        Variable var = (Variable)this.varTbl.get(name);
        if (var == null) {
            throw new LookupException(name);
        }
        return var;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Timing timing = new Timing();
        int size = this.stmtNodeList.size();
        for (int i = 0; i < size; ++i) {
            StatementNode stmt = this.stmtNodeList.get(i);
            if (this.isEchoOn()) {
                env.out.println(Indent.addIndent(stmt.toString(), Env.promptText));
            }
            if (this.isTimeOn()) {
                timing.start();
            }
            Value stmtVal = stmt.evaluate(env);
            if (this.isTimeOn()) {
                timing.stop();
                env.out.print("time:\t");
                env.out.println(stmt.shortFormLocation() + " " + timing.getTime());
            }
            if (stmtVal == Value.EVAL) continue;
            return stmtVal;
        }
        return Value.EVAL;
    }

    public Value debugEvaluate(Env env, int qdbCode) throws EvaluationException {
        Timing timing = new Timing();
        int size = this.stmtNodeList.size();
        if (this.currStmtNum >= size) {
            env.out.println("[qdb]: no more scripts left");
            return Value.EVAL;
        }
        if (qdbCode == 2) {
            StatementNode stmt = this.stmtNodeList.get(this.currStmtNum);
            env.out.println(stmt.shortFormLocation());
            env.out.println(stmt.toString());
            return Value.EVAL;
        }
        if (qdbCode == 1) {
            this.getOption().setPauseOn(false);
        }
        boolean pause = false;
        while (this.currStmtNum < size && !pause) {
            StatementNode stmt = this.stmtNodeList.get(this.currStmtNum);
            if (this.isEchoOn()) {
                env.out.println(Indent.addIndent(stmt.toString(), Env.promptText));
            }
            if (this.isTimeOn()) {
                timing.start();
            }
            Value stmtVal = stmt.evaluate(env);
            if (this.isTimeOn()) {
                timing.stop();
                env.out.print("time:\t");
                env.out.println(stmt.shortFormLocation() + " " + timing.getTime());
            }
            switch (qdbCode) {
                case 1: {
                    if (!this.isPauseOn()) break;
                    pause = true;
                    break;
                }
                case 3: {
                    pause = true;
                    break;
                }
                default: {
                    pause = false;
                }
            }
            if (stmtVal != Value.EVAL) {
                this.currStmtNum = size;
                return stmtVal;
            }
            ++this.currStmtNum;
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.stmtNodeList.size(); ++i) {
            buffer.append(this.stmtNodeList.get(i));
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    public void incrEchoIndent() {
        this.echoIndent.append("\t");
    }

    public void decrEchoIndent() {
        int len = this.echoIndent.length();
        if (len > 0) {
            this.echoIndent.delete(len - 1, len);
        }
    }

    public String getEchoIndent() {
        return this.echoIndent.toString();
    }

    private class UnitContainer {
        ArrayList<ScriptUnitNode> list = new ArrayList(5);

        UnitContainer(ScriptUnitNode unit) {
            this.list.add(unit);
        }

        void add(ScriptUnitNode unit) {
            this.list.add(unit);
        }
    }
}

