/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class SuffixExpressionNode
extends ExpressionNode {
    int op = -100;
    ExpressionNode expNode;

    public SuffixExpressionNode(ExpressionNode expNode) {
        this.expNode = expNode;
    }

    public SuffixExpressionNode(ExpressionNode expNode, int op) {
        this.op = op;
        this.expNode = expNode;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.expNode.propagate(env, userObj);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value val = this.expNode.evaluate(env);
        if (val.getType() != EdgeSet.class) {
            throw new EvaluationException((SyntaxTreeNode)this, "EdgeSet expected for op: " + Operator.key(this.op));
        }
        EdgeSet set = (EdgeSet)val.objectValue();
        switch (this.op) {
            case 15: {
                return new Value(AlgebraOperation.reflectiveClosure(set));
            }
            case 12: {
                return new Value(AlgebraOperation.transitiveClosure(set));
            }
            case -100: {
                return val;
            }
        }
        throw new EvaluationException((SyntaxTreeNode)this, "illegal expression: " + val.getType() + " " + Operator.key(this.op));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.expNode);
        buffer.append(" ");
        buffer.append(Operator.key(this.op));
        return buffer.toString();
    }
}

