/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;

public class Type {
    public static final int MATCH = 0;
    public static final int NOT_MATCH = -10000;

    public static Class<?> findType(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("string")) {
            return String.class;
        }
        if (name.equals("String")) {
            return String.class;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("NodeSet")) {
            return NodeSet.class;
        }
        if (name.equals("EdgeSet")) {
            return EdgeSet.class;
        }
        if (name.equals("TupleSet")) {
            return TupleSet.class;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String findName(Class<?> type) {
        if (type == null) {
            return "...";
        }
        String name = type.getName();
        if (Type.isPrimitive(type)) {
            return name;
        }
        if (name.equals("java.lang.String")) {
            return "String";
        }
        if (name.endsWith(".NodeSet")) {
            return "NodeSet";
        }
        if (name.endsWith(".EdgeSet")) {
            return "EdgeSet";
        }
        if (name.endsWith(".TupleSet")) {
            return "TupleSet";
        }
        int index = name.indexOf(32);
        name = name.substring(index + 1);
        return name;
    }

    public static int distanceTo(Class<?> t1, Class<?> t2) {
        if (Type.isIdentical(t1, t2)) {
            return 0;
        }
        return Type.computeDistance(t1, t2);
    }

    public static int distanceTo(Class<?>[] argTypes, Class<?>[] paramTypes) {
        int dist = 0;
        int numArgs = argTypes.length;
        int numParams = paramTypes.length;
        if (numArgs != numParams) {
            return -10000;
        }
        if (numArgs == 0) {
            return 0;
        }
        for (int i = 0; i < numArgs && (dist += Type.distanceTo(argTypes[i], paramTypes[i])) >= 0; ++i) {
        }
        return dist;
    }

    private static int computeDistance(Class<?> t1, Class<?> t2) {
        int dist = 0;
        Class<?> supType = t1.getSuperclass();
        if (supType != null) {
            dist = t2 == supType ? ++dist : (supType == Object.class ? -10000 : 1 + Type.distanceTo(supType, t2));
        }
        if (dist > 0) {
            return dist;
        }
        dist = 0;
        Class<?>[] interfaces = t1.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                dist = 0;
                Class<?> infType = interfaces[i];
                if (t2 == infType) {
                    ++dist;
                } else {
                    dist = 1 + Type.distanceTo(infType, t2);
                    if (dist <= 0) {
                        dist = -10000;
                        continue;
                    }
                }
                break;
            }
        } else {
            dist = -10000;
        }
        if (dist > 0) {
            return dist;
        }
        return -10000;
    }

    public static boolean isPrimitive(Class<?> t) {
        return t == Integer.TYPE || t == Float.TYPE || t == Long.TYPE || t == Double.TYPE || t == Boolean.TYPE || t == Void.TYPE;
    }

    public static boolean isIdentical(Class<?> t1, Class<?> t2) {
        return t1 == t2;
    }

    public static boolean isSubtypeOf(Class<?> t1, Class<?> t2) {
        return Type.distanceTo(t1, t2) >= 0;
    }

    public static boolean isRelatedTo(Class<?> t1, Class<?> t2) {
        return Type.distanceTo(t1, t2) >= 0 || Type.distanceTo(t2, t1) >= 0;
    }
}

