/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.op.BooleanOperation;
import ca.uwaterloo.cs.jgrok.interp.op.EdgeSetAnyOperation;
import ca.uwaterloo.cs.jgrok.interp.op.EdgeSetOperation;
import ca.uwaterloo.cs.jgrok.interp.op.FloatOperation;
import ca.uwaterloo.cs.jgrok.interp.op.IntOperation;
import ca.uwaterloo.cs.jgrok.interp.op.NodeSetAnyOperation;
import ca.uwaterloo.cs.jgrok.interp.op.NodeSetOperation;
import ca.uwaterloo.cs.jgrok.interp.op.StringOperation;
import ca.uwaterloo.cs.jgrok.interp.op.TupleSetAnyOperation;
import ca.uwaterloo.cs.jgrok.interp.op.TupleSetOperation;
import java.util.ArrayList;
import java.util.Hashtable;

public class TypeOperation {
    private static Hashtable<String, ArrayList<TypeOperation>> allTOPs = new Hashtable();
    private int op;
    private Class<?> type;
    private Class<?>[] params;
    private Operation operation;

    public static TypeOperation analyze(int op, Class<?> param) {
        if (param == null || param == Void.TYPE) {
            return null;
        }
        TypeOperation vp = new TypeOperation(op, null, param);
        return vp.lookup();
    }

    public static TypeOperation analyze(int op, Class<?> param1, Class<?> param2) {
        if (param1 == null || param2 == null || param1 == Void.TYPE || param2 == Void.TYPE) {
            return null;
        }
        TypeOperation vp = new TypeOperation(op, null, param1, param2);
        return vp.lookup();
    }

    private static void add(String key, TypeOperation TOP) {
        TypeOperation typeOP;
        ArrayList<TypeOperation> list = null;
        list = allTOPs.get(key);
        if (list == null) {
            list = new ArrayList(5);
            allTOPs.put(key, list);
        }
        switch (TOP.params.length) {
            case 1: {
                typeOP = new TypeOperation(Operator.op(key), TOP.type, TOP.params[0], TOP.operation);
                break;
            }
            case 2: {
                typeOP = new TypeOperation(Operator.op(key), TOP.type, TOP.params[0], TOP.params[1], TOP.operation);
                break;
            }
            default: {
                typeOP = TOP;
            }
        }
        list.add(typeOP);
    }

    public int getOp() {
        return this.op;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?>[] getParams() {
        return this.params;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.params.length == 2) {
            buf.append(this.type.toString());
            buf.append(" = ");
            buf.append(this.params[0].toString());
            buf.append(' ');
            buf.append(Operator.key(this.op));
            buf.append(' ');
            buf.append(this.params[1].toString());
        } else {
            buf.append(this.type.toString());
            buf.append(" = ");
            buf.append(Operator.key(this.op));
            buf.append(' ');
            buf.append(this.params[0].toString());
        }
        return buf.toString();
    }

    private TypeOperation(int op, Class<?> type, Class<?> param) {
        this.op = op;
        this.type = type;
        this.params = new Class[1];
        this.params[0] = param;
    }

    private TypeOperation(int op, Class<?> type, Class<?> param1, Class<?> param2) {
        this.op = op;
        this.type = type;
        this.params = new Class[2];
        this.params[0] = param1;
        this.params[1] = param2;
    }

    private TypeOperation(int op, Class<?> type, Class<?> param, Operation operation) {
        this.op = op;
        this.type = type;
        this.params = new Class[1];
        this.params[0] = param;
        this.operation = operation;
    }

    private TypeOperation(int op, Class<?> type, Class<?> param1, Class<?> param2, Operation operation) {
        this.op = op;
        this.type = type;
        this.params = new Class[2];
        this.params[0] = param1;
        this.params[1] = param2;
        this.operation = operation;
    }

    private TypeOperation lookup() {
        String key = Operator.key(this.op);
        ArrayList<TypeOperation> list = allTOPs.get(key);
        if (list == null) {
            return null;
        }
        TypeOperation result = null;
        int distOld = 1000;
        for (int i = 0; i < list.size(); ++i) {
            TypeOperation TOP = list.get(i);
            int distNew = this.distanceMatch(TOP);
            if (distNew >= 0) {
                if (result == null) {
                    result = TOP;
                    distOld = distNew;
                } else if (distNew < distOld) {
                    result = TOP;
                    distOld = distNew;
                }
            }
            if (distNew == 0) break;
        }
        return result;
    }

    private int distanceMatch(TypeOperation TOP) {
        int distance = 0;
        Class<?>[] testParams = TOP.getParams();
        if (this.params.length != testParams.length) {
            return -1000;
        }
        if (this.params.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.params.length && (distance += TypeOperation.distanceTo(this.params[i], testParams[i])) >= 0; ++i) {
        }
        return distance;
    }

    private static int distanceTo(Class<?> v1, Class<?> v2) {
        if (v1 == Long.TYPE || v1 == Short.TYPE) {
            v1 = Integer.TYPE;
        } else if (v1 == Double.TYPE) {
            v1 = Float.TYPE;
        }
        if (v1 == v2) {
            return 0;
        }
        if (v1 == Integer.TYPE) {
            if (v2 == Float.TYPE) {
                return 1;
            }
            if (v2 == Object.class) {
                return 2;
            }
            return -1000;
        }
        if (v1 == Float.TYPE) {
            if (v2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        if (v1 == Boolean.TYPE) {
            if (v2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        if (v1 == String.class) {
            if (v2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        if (v1 == EdgeSet.class) {
            if (v2 == TupleSet.class) {
                return 1;
            }
            if (v2 == Object.class) {
                return 2;
            }
            return -1000;
        }
        if (v1 == NodeSet.class) {
            if (v2 == TupleSet.class) {
                return 1;
            }
            if (v2 == Object.class) {
                return 2;
            }
            return -1000;
        }
        if (v1 == TupleSet.class && v2 == Object.class) {
            return 1;
        }
        return -1000;
    }

    static {
        IntOperation intOPs = new IntOperation();
        FloatOperation floatOPs = new FloatOperation();
        StringOperation stringOPs = new StringOperation();
        BooleanOperation booleanOPs = new BooleanOperation();
        NodeSetOperation nsetOPs = new NodeSetOperation();
        EdgeSetOperation esetOPs = new EdgeSetOperation();
        TupleSetOperation tsetOPs = new TupleSetOperation();
        NodeSetAnyOperation _NxOPs = new NodeSetAnyOperation();
        EdgeSetAnyOperation _ExOPs = new EdgeSetAnyOperation();
        TupleSetAnyOperation _TxOPs = new TupleSetAnyOperation();
        TypeOperation I_I = new TypeOperation(-1, Integer.TYPE, Integer.TYPE, intOPs);
        TypeOperation.add("-", I_I);
        TypeOperation F_F = new TypeOperation(-1, Float.TYPE, Float.TYPE, floatOPs);
        TypeOperation.add("-", F_F);
        TypeOperation B_B = new TypeOperation(-1, Boolean.TYPE, Boolean.TYPE, booleanOPs);
        TypeOperation.add("!", B_B);
        TypeOperation.add("!", B_B);
        TypeOperation I_T = new TypeOperation(-1, Integer.TYPE, TupleSet.class, tsetOPs);
        TypeOperation.add("#", I_T);
        TypeOperation T_T = new TypeOperation(-1, TupleSet.class, TupleSet.class, tsetOPs);
        TypeOperation.add("id", T_T);
        TypeOperation.add("inv", T_T);
        TypeOperation.add("ent", T_T);
        TypeOperation.add("dom", T_T);
        TypeOperation.add("rng", T_T);
        TypeOperation B_OT = new TypeOperation(-1, Boolean.TYPE, Object.class, TupleSet.class, tsetOPs);
        TypeOperation.add("in", B_OT);
        TypeOperation I_II = new TypeOperation(-1, Integer.TYPE, Integer.TYPE, Integer.TYPE, intOPs);
        TypeOperation B_II = new TypeOperation(-1, Boolean.TYPE, Integer.TYPE, Integer.TYPE, intOPs);
        TypeOperation.add("+", I_II);
        TypeOperation.add("-", I_II);
        TypeOperation.add("*", I_II);
        TypeOperation.add("/", I_II);
        TypeOperation.add("%", I_II);
        TypeOperation.add("==", B_II);
        TypeOperation.add("!=", B_II);
        TypeOperation.add(">", B_II);
        TypeOperation.add(">=", B_II);
        TypeOperation.add("<", B_II);
        TypeOperation.add("<=", B_II);
        TypeOperation F_FF = new TypeOperation(-1, Float.TYPE, Float.TYPE, Float.TYPE, floatOPs);
        TypeOperation B_FF = new TypeOperation(-1, Boolean.TYPE, Float.TYPE, Float.TYPE, floatOPs);
        TypeOperation.add("+", F_FF);
        TypeOperation.add("-", F_FF);
        TypeOperation.add("*", F_FF);
        TypeOperation.add("/", F_FF);
        TypeOperation.add("==", B_FF);
        TypeOperation.add("!=", B_FF);
        TypeOperation.add(">", B_FF);
        TypeOperation.add(">=", B_FF);
        TypeOperation.add("<", B_FF);
        TypeOperation.add("<=", B_FF);
        TypeOperation B_SS = new TypeOperation(-1, Boolean.TYPE, String.class, String.class, stringOPs);
        TypeOperation S_SO = new TypeOperation(-1, String.class, String.class, Object.class, stringOPs);
        TypeOperation S_OS = new TypeOperation(-1, String.class, Object.class, String.class, stringOPs);
        TypeOperation.add("==", B_SS);
        TypeOperation.add("!=", B_SS);
        TypeOperation.add("<", B_SS);
        TypeOperation.add("<=", B_SS);
        TypeOperation.add(">", B_SS);
        TypeOperation.add(">=", B_SS);
        TypeOperation.add("=~", B_SS);
        TypeOperation.add("!~", B_SS);
        TypeOperation.add("+", S_SO);
        TypeOperation.add("+", S_OS);
        TypeOperation B_BB = new TypeOperation(-1, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, booleanOPs);
        TypeOperation.add("==", B_BB);
        TypeOperation.add("!=", B_BB);
        TypeOperation B_NN = new TypeOperation(-1, Boolean.TYPE, NodeSet.class, NodeSet.class, nsetOPs);
        TypeOperation.add("==", B_NN);
        TypeOperation.add("!=", B_NN);
        TypeOperation.add("<", B_NN);
        TypeOperation.add("<=", B_NN);
        TypeOperation.add(">", B_NN);
        TypeOperation.add(">=", B_NN);
        TypeOperation B_EE = new TypeOperation(-1, Boolean.TYPE, EdgeSet.class, EdgeSet.class, esetOPs);
        TypeOperation.add("==", B_EE);
        TypeOperation.add("!=", B_EE);
        TypeOperation.add("<", B_EE);
        TypeOperation.add("<=", B_EE);
        TypeOperation.add(">", B_EE);
        TypeOperation.add(">=", B_EE);
        TypeOperation B_TT = new TypeOperation(-1, Boolean.TYPE, TupleSet.class, TupleSet.class, tsetOPs);
        TypeOperation.add("==", B_TT);
        TypeOperation.add("!=", B_TT);
        TypeOperation.add("<", B_TT);
        TypeOperation.add("<=", B_TT);
        TypeOperation.add(">", B_TT);
        TypeOperation.add(">=", B_TT);
        TypeOperation N_NN = new TypeOperation(-1, NodeSet.class, NodeSet.class, NodeSet.class, nsetOPs);
        TypeOperation.add("+", N_NN);
        TypeOperation.add("-", N_NN);
        TypeOperation.add("^", N_NN);
        TypeOperation.add("X", N_NN);
        TypeOperation E_EE = new TypeOperation(-1, EdgeSet.class, EdgeSet.class, EdgeSet.class, esetOPs);
        TypeOperation.add("+", E_EE);
        TypeOperation.add("-", E_EE);
        TypeOperation.add("^", E_EE);
        TypeOperation.add("o", E_EE);
        TypeOperation.add("*", E_EE);
        TypeOperation T_EE = new TypeOperation(-1, TupleSet.class, EdgeSet.class, EdgeSet.class, esetOPs);
        TypeOperation.add("**", T_EE);
        TypeOperation E_EN = new TypeOperation(-1, EdgeSet.class, EdgeSet.class, NodeSet.class, _ExOPs);
        TypeOperation E_NE = new TypeOperation(-1, EdgeSet.class, NodeSet.class, EdgeSet.class, _NxOPs);
        TypeOperation.add("o", E_EN);
        TypeOperation.add("o", E_NE);
        TypeOperation.add("*", E_EN);
        TypeOperation.add("*", E_NE);
        TypeOperation N_NE = new TypeOperation(-1, NodeSet.class, NodeSet.class, EdgeSet.class, _NxOPs);
        TypeOperation N_EN = new TypeOperation(-1, NodeSet.class, EdgeSet.class, NodeSet.class, _ExOPs);
        TypeOperation.add(".", N_NE);
        TypeOperation.add(".", N_EN);
        TypeOperation T_TT = new TypeOperation(-1, TupleSet.class, TupleSet.class, TupleSet.class, tsetOPs);
        TypeOperation.add("+", T_TT);
        TypeOperation.add("-", T_TT);
        TypeOperation.add("o", T_TT);
        TypeOperation.add("*", T_TT);
        TypeOperation.add("^", T_TT);
        TypeOperation T_TN = new TypeOperation(-1, TupleSet.class, TupleSet.class, NodeSet.class, _TxOPs);
        TypeOperation T_NT = new TypeOperation(-1, TupleSet.class, NodeSet.class, TupleSet.class, _NxOPs);
        TypeOperation.add("o", T_TN);
        TypeOperation.add("o", T_NT);
        TypeOperation.add("*", T_TN);
        TypeOperation.add("*", T_NT);
        TypeOperation.add(".", T_NT);
        TypeOperation.add(".", T_TN);
        TypeOperation T_TE = new TypeOperation(-1, TupleSet.class, TupleSet.class, EdgeSet.class, _TxOPs);
        TypeOperation T_ET = new TypeOperation(-1, TupleSet.class, EdgeSet.class, TupleSet.class, _ExOPs);
        TypeOperation.add("o", T_TE);
        TypeOperation.add("o", T_ET);
        TypeOperation.add("*", T_TE);
        TypeOperation.add("*", T_ET);
        TypeOperation.add("**", E_NE);
        TypeOperation.add("**", E_EN);
        TypeOperation.add("**", T_NT);
        TypeOperation.add("**", T_TN);
        TypeOperation.add("**", T_TE);
        TypeOperation.add("**", T_ET);
        TypeOperation.add("**", T_TT);
        TypeOperation.add("**", T_EE);
    }
}

