/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Clazz;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.Type;
import java.io.PrintStream;

public class Value {
    Object val;
    Class<?> primitiveType;
    public static final Value VOID = new Value();
    public static final Value EVAL = new Value();

    protected Value() {
        this.val = new Object();
        this.primitiveType = null;
    }

    public Value(int i) {
        this.val = new Integer(i);
        this.primitiveType = Integer.TYPE;
    }

    public Value(long l) {
        this.val = new Long(l);
        this.primitiveType = Long.TYPE;
    }

    public Value(short s) {
        this.val = new Short(s);
        this.primitiveType = Short.TYPE;
    }

    public Value(float f) {
        this.val = new Float(f);
        this.primitiveType = Float.TYPE;
    }

    public Value(double d) {
        this.val = new Double(d);
        this.primitiveType = Double.TYPE;
    }

    public Value(boolean b) {
        this.val = new Boolean(b);
        this.primitiveType = Boolean.TYPE;
    }

    public Value(Object o) {
        this.val = o;
        this.primitiveType = null;
    }

    public Value(Object o, Class<?> clazz) {
        this.val = o;
        this.primitiveType = Clazz.isJavaPrimitive(clazz) ? clazz : null;
    }

    public Class<?> getType() {
        if (this.primitiveType != null) {
            return this.primitiveType;
        }
        return this.val.getClass();
    }

    public String getTypeName() {
        return Type.findName(this.getType());
    }

    public boolean isBoolean() {
        return this.primitiveType == Boolean.TYPE;
    }

    public boolean isNumeric() {
        return this.primitiveType != null;
    }

    public boolean isString() {
        return this.val.getClass() == String.class;
    }

    public boolean isPrimitive() {
        return this.isNumeric() || this.isString();
    }

    public boolean isNodeSet() {
        return this.val instanceof NodeSet;
    }

    public boolean isEdgeSet() {
        return this.val instanceof EdgeSet;
    }

    public String toString() {
        if (this.val == null) {
            return "null";
        }
        return this.val.toString();
    }

    public void cantConvert(String type) throws NumberFormatException {
        throw new NumberFormatException("Can't convert " + this.getTypeName() + "[" + this.toString() + "] to " + type);
    }

    public boolean booleanValue() throws NumberFormatException {
        if (this.primitiveType == Boolean.TYPE) {
            return (Boolean)this.val;
        }
        this.cantConvert("boolean");
        return false;
    }

    public short shortValue() throws NumberFormatException {
        int ret;
        if (this.primitiveType == Short.TYPE) {
            return (Short)this.val;
        }
        if (this.primitiveType == Integer.TYPE && (ret = ((Integer)this.val).intValue()) >= Short.MIN_VALUE && ret <= Short.MAX_VALUE) {
            return (short)ret;
        }
        if (this.primitiveType == Long.TYPE && (ret = ((Long)this.val).longValue()) >= -32768L && ret <= 32767L) {
            return (short)ret;
        }
        if (this.primitiveType == Float.TYPE && (ret = ((Float)this.val).floatValue()) >= -32768.0f && ret <= 32767.0f) {
            return (short)ret;
        }
        if (this.primitiveType == Double.TYPE && (ret = ((Double)this.val).doubleValue()) >= -32768.0 && ret <= 32767.0) {
            return (short)ret;
        }
        if (this.primitiveType == String.class) {
            return Short.parseShort(this.toString());
        }
        this.cantConvert("short");
        return 0;
    }

    public int intValue() throws NumberFormatException {
        long ret;
        if (this.primitiveType == Integer.TYPE) {
            return (Integer)this.val;
        }
        if (this.primitiveType == Long.TYPE && (ret = ((Long)this.val).longValue()) >= Integer.MIN_VALUE && ret <= Integer.MAX_VALUE) {
            return (int)ret;
        }
        if (this.primitiveType == Short.TYPE) {
            return ((Short)this.val).shortValue();
        }
        if (this.primitiveType == Float.TYPE && (ret = ((Float)this.val).floatValue()) >= -2.1474836E9f && ret <= 2.1474836E9f) {
            return (int)ret;
        }
        if (this.primitiveType == Double.TYPE && (ret = ((Double)this.val).doubleValue()) >= -2.147483648E9 && ret <= 2.147483647E9) {
            return (int)ret;
        }
        if (this.primitiveType == String.class) {
            return Integer.parseInt(this.toString());
        }
        this.cantConvert("int");
        return 0;
    }

    public long longValue() throws NumberFormatException {
        float ret;
        if (this.primitiveType == Long.TYPE) {
            return (Long)this.val;
        }
        if (this.primitiveType == Integer.TYPE) {
            return ((Integer)this.val).intValue();
        }
        if (this.primitiveType == Short.TYPE) {
            return ((Short)this.val).shortValue();
        }
        if (this.primitiveType == Float.TYPE && (ret = ((Float)this.val).floatValue()) >= -9.223372E18f && ret <= 9.223372E18f) {
            return (long)ret;
        }
        if (this.primitiveType == Double.TYPE && (ret = ((Double)this.val).doubleValue()) >= -9.223372036854776E18 && ret <= 9.223372036854776E18) {
            return (long)ret;
        }
        if (this.primitiveType == String.class) {
            return Long.parseLong(this.toString());
        }
        this.cantConvert("long");
        return 0L;
    }

    public float floatValue() throws NumberFormatException {
        double ret;
        if (this.primitiveType == Float.TYPE) {
            return ((Float)this.val).floatValue();
        }
        if (this.primitiveType == Double.TYPE && (ret = ((Double)this.val).doubleValue()) >= (double)1.4E-45f && ret <= 3.4028234663852886E38) {
            return (float)ret;
        }
        if (this.primitiveType == Integer.TYPE) {
            return ((Integer)this.val).intValue();
        }
        if (this.primitiveType == Long.TYPE && (float)(ret = ((Long)this.val).longValue()) >= Float.MIN_VALUE && (float)ret <= Float.MAX_VALUE) {
            return ret;
        }
        if (this.primitiveType == Short.TYPE) {
            return ((Short)this.val).shortValue();
        }
        if (this.primitiveType == String.class) {
            return Float.parseFloat(this.toString());
        }
        this.cantConvert("float");
        return 0.0f;
    }

    public double doubleValue() throws NumberFormatException {
        if (this.primitiveType == Double.TYPE) {
            return (Double)this.val;
        }
        if (this.primitiveType == Float.TYPE) {
            return ((Float)this.val).floatValue();
        }
        if (this.primitiveType == Integer.TYPE) {
            return ((Integer)this.val).intValue();
        }
        if (this.primitiveType == Long.TYPE) {
            return ((Long)this.val).longValue();
        }
        if (this.primitiveType == Short.TYPE) {
            return ((Short)this.val).shortValue();
        }
        if (this.primitiveType == String.class) {
            return Double.parseDouble(this.toString());
        }
        this.cantConvert("double");
        return 0.0;
    }

    public String stringValue() {
        return this.val.toString();
    }

    public Object objectValue() {
        return this.val;
    }

    public TupleSet tupleSetValue() {
        if (this.val instanceof TupleSet || this.val instanceof NodeSet || this.val instanceof EdgeSet) {
            return (TupleSet)this.val;
        }
        this.cantConvert("TupleSet");
        return null;
    }

    public NodeSet nodeSetValue() {
        if (this.val instanceof NodeSet) {
            return (NodeSet)this.val;
        }
        this.cantConvert("NodeSet");
        return null;
    }

    public EdgeSet edgeSetValue() {
        if (this.val instanceof EdgeSet) {
            return (EdgeSet)this.val;
        }
        this.cantConvert("EdgeSet");
        return null;
    }

    public void set(int i) {
        this.val = new Integer(i);
        this.primitiveType = Integer.TYPE;
    }

    public void set(long l) {
        this.val = new Long(l);
        this.primitiveType = Long.TYPE;
    }

    public void set(short s) {
        this.val = new Short(s);
        this.primitiveType = Short.TYPE;
    }

    public void set(float f) {
        this.val = new Float(f);
        this.primitiveType = Float.TYPE;
    }

    public void set(double d) {
        this.val = new Double(d);
        this.primitiveType = Double.TYPE;
    }

    public void set(boolean b) {
        this.val = new Boolean(b);
        this.primitiveType = Boolean.TYPE;
    }

    public void set(Object o) {
        this.val = o;
        this.primitiveType = null;
    }

    public void print(PrintStream ps) {
        if (this.isPrimitive()) {
            if (this.primitiveType != Void.TYPE) {
                ps.println(this);
            }
        } else if (this.val instanceof Value[]) {
            Value[] vals = (Value[])this.val;
            for (int i = 0; i < vals.length; ++i) {
                vals[i].print(ps);
            }
        } else if (Type.isSubtypeOf(this.getType(), TupleSet.class)) {
            ((TupleSet)this.val).print(ps);
        } else {
            ps.println(this.val);
        }
    }

    static {
        Value.VOID.primitiveType = Void.TYPE;
        Value.EVAL.primitiveType = Void.TYPE;
    }
}

