/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.Value;
import java.util.regex.PatternSyntaxException;

public class ValueMath {
    public static Value eval(int op, Value left, Value right) throws EvaluationException {
        switch (op) {
            case 0: {
                return ValueMath.eval_GT(left, right);
            }
            case 1: {
                return ValueMath.eval_LT(left, right);
            }
            case 2: {
                return ValueMath.eval_EQ(left, right);
            }
            case 5: {
                return ValueMath.eval_NE(left, right);
            }
            case 4: {
                return ValueMath.eval_GE(left, right);
            }
            case 3: {
                return ValueMath.eval_LE(left, right);
            }
            case 6: {
                return ValueMath.eval_ME(left, right);
            }
            case 7: {
                return ValueMath.eval_UE(left, right);
            }
        }
        return Value.VOID;
    }

    public static Value eval_GT(Value left, Value right) {
        String sRight;
        double[] doubles = ValueMath.bothDouble(left, right);
        if (doubles != null) {
            return new Value(doubles[0] > doubles[1]);
        }
        String sLeft = left.toString();
        return new Value(sLeft.compareTo(sRight = right.toString()) > 0);
    }

    public static Value eval_LT(Value left, Value right) {
        String sRight;
        double[] doubles = ValueMath.bothDouble(left, right);
        if (doubles != null) {
            return new Value(doubles[0] < doubles[1]);
        }
        String sLeft = left.toString();
        return new Value(sLeft.compareTo(sRight = right.toString()) < 0);
    }

    public static Value eval_EQ(Value left, Value right) {
        String sRight;
        double[] doubles = ValueMath.bothDouble(left, right);
        if (doubles != null) {
            return new Value(doubles[0] == doubles[1]);
        }
        String sLeft = left.toString();
        return new Value(sLeft.compareTo(sRight = right.toString()) == 0);
    }

    public static Value eval_NE(Value left, Value right) {
        String sRight;
        double[] doubles = ValueMath.bothDouble(left, right);
        if (doubles != null) {
            return new Value(doubles[0] != doubles[1]);
        }
        String sLeft = left.toString();
        return new Value(sLeft.compareTo(sRight = right.toString()) != 0);
    }

    public static Value eval_GE(Value left, Value right) {
        String sRight;
        double[] doubles = ValueMath.bothDouble(left, right);
        if (doubles != null) {
            return new Value(doubles[0] >= doubles[1]);
        }
        String sLeft = left.toString();
        return new Value(sLeft.compareTo(sRight = right.toString()) >= 0);
    }

    public static Value eval_LE(Value left, Value right) {
        String sRight;
        double[] doubles = ValueMath.bothDouble(left, right);
        if (doubles != null) {
            return new Value(doubles[0] <= doubles[1]);
        }
        String sLeft = left.toString();
        return new Value(sLeft.compareTo(sRight = right.toString()) <= 0);
    }

    public static Value eval_ME(Value left, Value right) throws EvaluationException {
        String sLeft = left.toString();
        String sRight = right.toString();
        if (sLeft.matches(sRight)) {
            return new Value(true);
        }
        return new Value(false);
    }

    public static Value eval_UE(Value left, Value right) throws PatternSyntaxException {
        String sLeft = left.toString();
        String sRight = right.toString();
        if (!sLeft.matches(sRight)) {
            return new Value(true);
        }
        return new Value(false);
    }

    private static double[] bothDouble(Value v0, Value v1) {
        try {
            double d0 = v0.doubleValue();
            double d1 = v1.doubleValue();
            double[] d = new double[]{d0, d1};
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }
}

