/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvalName;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import java.lang.reflect.Field;

public class VariableNode
extends ExpressionNode
implements EvalName {
    String name;

    public VariableNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        try {
            Variable var = env.lookup(this.name);
            if (var.getValue() == null) {
                throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errUnresolvable(this.name));
            }
            return var.getValue();
        }
        catch (LookupException e) {
            try {
                Value[] argValues = new Value[]{};
                Function function = env.lookupFunction(this.name);
                try {
                    return function.invoke(env, argValues);
                }
                catch (Exception inv) {
                    throw new EvaluationException((SyntaxTreeNode)this, this.name + "(): " + inv.getMessage());
                }
            }
            catch (LookupException e2) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
    }

    @Override
    public String evalName(Env env) throws EvaluationException {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    Value evalClassField(Env env, Class<?> clazz) throws NoSuchFieldException, EvaluationException {
        String fName = this.evalName(env);
        if (fName.equals("class")) {
            return new Value(clazz);
        }
        Field f = clazz.getDeclaredField(fName);
        try {
            return new Value(f.get(null), f.getType());
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((SyntaxTreeNode)this, e);
        }
    }

    Value evalInstanceField(Env env, Object obj) throws NoSuchFieldException, EvaluationException {
        String fName = this.evalName(env);
        Field f = obj.getClass().getDeclaredField(fName);
        try {
            return new Value(f.get(obj), f.getType());
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((SyntaxTreeNode)this, e);
        }
    }
}

