/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.LocalScopedNode;
import ca.uwaterloo.cs.jgrok.interp.StatementNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class WhileStatementNode
extends StatementNode {
    ExpressionNode expNode;
    StatementNode bodyNode;

    public WhileStatementNode(ExpressionNode expNode, StatementNode bodyNode) {
        this.expNode = expNode;
        this.bodyNode = bodyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value evaluate(Env env) throws EvaluationException {
        block5: {
            env.pushScope(new LocalScopedNode(env.peepScope()));
            try {
                Value stmtVal;
                do {
                    Value expVal;
                    if ((expVal = this.expNode.evaluate(env)).getType() != Boolean.TYPE) {
                        throw new EvaluationException((SyntaxTreeNode)this.expNode, "not boolean");
                    }
                    if (expVal.booleanValue()) continue;
                    break block5;
                } while ((stmtVal = this.bodyNode.evaluate(env)) == Value.EVAL);
                Value value = stmtVal;
                return value;
            }
            finally {
                env.popScope();
            }
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("while");
        buffer.append('(');
        buffer.append(this.expNode);
        buffer.append(')');
        buffer.append(' ');
        buffer.append(this.bodyNode);
        return buffer.toString();
    }
}

