/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.op;

import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.OperationException;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class BooleanOperation
extends Operation {
    @Override
    public Value eval(int op, Value v) throws OperationException {
        if (op == 11 || op == 28) {
            return new Value(!v.booleanValue());
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, Boolean.TYPE));
    }

    @Override
    public Value eval(int op, Value left, Value right) throws OperationException {
        boolean l = left.booleanValue();
        boolean r = right.booleanValue();
        switch (op) {
            case 2: {
                return new Value(l == r);
            }
            case 5: {
                return new Value(l != r);
            }
            case 9: {
                return new Value(l || r);
            }
            case 10: {
                return new Value(l && r);
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, Boolean.TYPE, Boolean.TYPE));
    }
}

