/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.op;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.RelationalOperation;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.OperationException;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class EdgeSetOperation
extends Operation {
    @Override
    public Value eval(int op, Value v) throws OperationException {
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, v.getType()));
    }

    @Override
    public Value eval(int op, Value left, Value right) throws OperationException {
        EdgeSet l = (EdgeSet)left.objectValue();
        EdgeSet r = (EdgeSet)right.objectValue();
        switch (op) {
            case 12: {
                return new Value(AlgebraOperation.union(l, r));
            }
            case 13: {
                return new Value(AlgebraOperation.difference(l, r));
            }
            case 16: {
                return new Value(AlgebraOperation.composition(l, r));
            }
            case 15: {
                return new Value(AlgebraOperation.composition(l, r));
            }
            case 17: {
                return new Value(AlgebraOperation.compositionRel(l, r));
            }
            case 14: {
                return new Value(AlgebraOperation.intersection(l, r));
            }
            case 0: {
                return new Value(RelationalOperation.GT(l, r));
            }
            case 1: {
                return new Value(RelationalOperation.LT(l, r));
            }
            case 2: {
                return new Value(RelationalOperation.EQ(l, r));
            }
            case 5: {
                return new Value(RelationalOperation.NE(l, r));
            }
            case 4: {
                return new Value(RelationalOperation.GE(l, r));
            }
            case 3: {
                return new Value(RelationalOperation.LE(l, r));
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, left.getType(), right.getType()));
    }
}

