/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.op;

import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.OperationException;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class IntOperation
extends Operation {
    @Override
    public Value eval(int op, Value v) throws OperationException {
        if (op == 13) {
            Class<?> type = v.getType();
            if (type != Integer.TYPE) {
                return new Value(0L - v.longValue());
            }
            return new Value(0 - v.intValue());
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, Long.TYPE));
    }

    @Override
    public Value eval(int op, Value left, Value right) throws OperationException {
        long l = left.longValue();
        long r = right.longValue();
        switch (op) {
            case 2: {
                return new Value(l == r);
            }
            case 5: {
                return new Value(l != r);
            }
            case 0: {
                return new Value(l > r);
            }
            case 4: {
                return new Value(l >= r);
            }
            case 1: {
                return new Value(l < r);
            }
            case 3: {
                return new Value(l <= r);
            }
            case 19: {
                return new Value(l % r);
            }
            case 12: {
                return new Value(l + r);
            }
            case 13: {
                return new Value(l - r);
            }
            case 15: {
                return new Value(l * r);
            }
            case 18: {
                return new Value(l / r);
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, Long.TYPE, Long.TYPE));
    }
}

