/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.op;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.RelationalOperation;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.OperationException;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class NodeSetOperation
extends Operation {
    @Override
    public Value eval(int op, Value v) throws OperationException {
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, v.getType()));
    }

    @Override
    public Value eval(int op, Value left, Value right) throws OperationException {
        NodeSet l = (NodeSet)left.objectValue();
        NodeSet r = (NodeSet)right.objectValue();
        switch (op) {
            case 12: {
                return new Value(AlgebraOperation.union(l, r));
            }
            case 13: {
                return new Value(AlgebraOperation.difference(l, r));
            }
            case 21: {
                return new Value(AlgebraOperation.crossProduct(l, r));
            }
            case 14: {
                return new Value(AlgebraOperation.intersection(l, r));
            }
            case 0: {
                return new Value(RelationalOperation.GT(l, r));
            }
            case 1: {
                return new Value(RelationalOperation.LT(l, r));
            }
            case 2: {
                return new Value(RelationalOperation.EQ(l, r));
            }
            case 5: {
                return new Value(RelationalOperation.NE(l, r));
            }
            case 4: {
                return new Value(RelationalOperation.GE(l, r));
            }
            case 3: {
                return new Value(RelationalOperation.LE(l, r));
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, left.getType(), right.getType()));
    }
}

